<?php

namespace App\Helpers;

class ApiResponse
{
    public static function success($data = [], $message = 'Operación exitosa', HttpCode $code = HttpCode::OK)
    {
        return response()->json([
            'success' => true,
            'message' => $message,
            'data'    => $data
        ], $code->value);
    }

    public static function successError($data = [], $message = 'Error', HttpCode $code = HttpCode::OK)
    {
        return response()->json([
            'success' => false,
            'message' => $message,
            'data'    => $data
        ], $code->value);
    }

    public static function error($message = 'Error en la operación', HttpCode $code = HttpCode::BAD_REQUEST, $data = [])
    {
        return response()->json([
            'success' => false,
            'message' => $message,
            'data'    => $data
        ], $code->value);
    }

    public static function unauthorized($message = 'No autorizado')
    {
        return self::error($message, HttpCode::UNAUTHORIZED);
    }

    public static function notFound($message = 'Recurso no encontrado')
    {
        return self::error($message, HttpCode::NOT_FOUND);
    }

    public static function serverError($message = 'Error interno del servidor')
    {
        return self::error($message, HttpCode::INTERNAL_SERVER_ERROR);
    }
}
