<?php

namespace App\Helpers;

use Exception;

class JwtAuth
{
    private static $secret_key = 'S0p0rt3.2025*'; // Change this to a secure key in production
    private static $encrypt = ['HS256'];

    public static function encode($data)
    {
        $header = json_encode(['typ' => 'JWT', 'alg' => 'HS256']);
        $payload = json_encode($data);

        $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));
        $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload));

        $signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, self::$secret_key, true);
        $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));

        return $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;
    }

    public static function decode($token)
    {
        try {
            $tokenParts = explode('.', $token);
            if (count($tokenParts) != 3) {
                return null;
            }

            $header = base64_decode(str_replace(['-', '_'], ['+', '/'], $tokenParts[0]));
            $payload = base64_decode(str_replace(['-', '_'], ['+', '/'], $tokenParts[1]));
            $signature_provided = $tokenParts[2];

            $signature = hash_hmac('sha256', $tokenParts[0] . "." . $tokenParts[1], self::$secret_key, true);
            $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));

            if ($base64UrlSignature === $signature_provided) {
                return json_decode($payload);
            }

            return null;
        } catch (Exception $e) {
            return null;
        }
    }

    public static function verify($token)
    {
        $decoded = self::decode($token);
        return !is_null($decoded);
    }
}
