<?php

namespace App\Helpers;
use Illuminate\Support\Str;
use App\Models\Usuario;

class Utils
{
    public static function generarNombreUsuarioUnico()
    {
        do {
            $letras = strtoupper(Str::random(4));
            $numeros = str_pad(mt_rand(0, 9999), 4, '0', STR_PAD_LEFT);

            $username = $letras . $numeros;

        } while (Usuario::where('username', $username)->exists());

        return $username;
    }

    public static function generarClaveInicial()
    {
        $letras = strtoupper(Str::random(4));
        $numeros = str_pad(mt_rand(0, 9999), 4, '0', STR_PAD_LEFT);

        $clave_inicial = $letras . $numeros;

        return $clave_inicial;
    }
}