<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\VListaAsignacion;
use App\Models\Color;
use App\Models\EstadoInstalacion;
use App\Models\TipoObjeto;
use App\Models\HpInstalacion;
use App\Models\Persona;
use App\Models\VCasa;
use App\Models\HpImagen;

class WSJobController extends Controller
{
    public function index($id_persona)
    {
        try {
            $hpinstalacion = VListaAsignacion::where('id_persona', $id_persona)->get();

            if ($hpinstalacion->isEmpty()) {
                return response()->json([
                    'message' => 'No se encontraron trabajos asignados para este usuario.',
                    'accepted' => true,
                    'data' => []
                ]);
            }

            return response()->json([
                'message' => 'Trabajos recuperados exitosamente.',
                'accepted' => true,
                'data' => $hpinstalacion
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Error en el servidor: ' . $e->getMessage(),
                'accepted' => false,
                'data' => []
            ], 500);
        }
    }

    public function getJob($id){

        try {
            $colors = Color::all();
            $estado_instalacion = EstadoInstalacion::all();
            $tipo_objeto = TipoObjeto::all();
            $hpinstalacion = HpInstalacion::where('id',$id)->first();
 
            $persona = Persona::where('id', $hpinstalacion->id_persona)->first();
            $supervisor = Persona::where('id', $hpinstalacion->id_persona_supervisor)->first();
            $casas = VCasa::where('id_casa', $hpinstalacion->id_casa)->first();

            $data_all = [
                'id' => $id,
                'hpinstalacion' => $hpinstalacion,
                'tipo_objeto' => $tipo_objeto,
                'persona' => $persona,
                'supervisor' => $supervisor,
                'casa' => $casas,
                'colors' => $colors,
                'estado_instalacion' => $estado_instalacion,
            ];

            if ($hpinstalacion==null) {
                return response()->json([
                    'message' => 'No se encontro el trabajo asignado para este usuario.',
                    'accepted' => true,
                    'data' => []
                ]);
            }

            return response()->json([
                'message' => 'Trabajo recuperado exitosamente.',
                'accepted' => true,
                'data' => $data_all
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Error en el servidor: ' . $e->getMessage(),
                'accepted' => false,
                'data' => []
            ], 500);
        }
    }

    public function update(Request $request, $id) 
    {
        try {
            DB::beginTransaction();

            $hpinstalacion = HpInstalacion::find($id);

            if (!$hpinstalacion) {
                return response()->json([
                    'message' => 'Trabajo no encontrado.',
                    'accepted' => false
                ], 404);
            }

            $data = $request->all();
            $fecha = now()->format('Y-m-d H:i:s');

            if(isset($data['id_estado_instalacion'])) {
                if($data['id_estado_instalacion'] == '1') {
                    $data['fecha_inicio'] = $fecha;
                }
                if($data['id_estado_instalacion'] == '2') {
                    $data['fecha_finalizacion'] = $fecha;
                }
                if($data['id_estado_instalacion'] == '3') {
                    $data['fecha_cancelacion'] = $fecha;
                }
            }
            
            $hpinstalacion->fill($data);
            $hpinstalacion->save();

            DB::commit();

            return response()->json([
                'message' => 'Trabajo actualizado exitosamente.',
                'accepted' => true
            ]);

        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'message' => 'Error al actualizar el trabajo: ' . $e->getMessage(),
                'accepted' => false
            ], 500);
        }
    }

    public function uploadImages(Request $request, $id)
    {
        try {
            DB::beginTransaction();

            $hpinstalacion = HpInstalacion::find($id);

            if (!$hpinstalacion) {
                return response()->json([
                    'message' => 'Trabajo no encontrado.',
                    'accepted' => false
                ], 404);
            }

            if (!$request->hasFile('images')) {
                return response()->json([
                    'message' => 'No se han enviado imágenes.',
                    'accepted' => false
                ], 400);
            }

            $images = $request->file('images');
            if (!is_array($images)) {
                $images = [$images];
            }
            
            $descriptions = $request->input('descriptions', []); 
            if (!is_array($descriptions)) {
                $descriptions = [$descriptions];
            }

            foreach ($images as $index => $image) {
                $imageName = time() . '_' . $image->getClientOriginalName();
                $image->move(public_path('assets/images/jobs'), $imageName);
                
                $description = isset($descriptions[$index]) ? $descriptions[$index] : '';

                HpImagen::create([
                    'id_hp_instalacion' => $id,
                    'nombre_imagen' => $imageName,
                    'descripcion' => $description,
                    'estado' => 'S' // Asumiendo estado activo por defecto
                ]);
            }

            DB::commit();

            return response()->json([
                'message' => 'Imágenes subidas exitosamente.',
                'accepted' => true
            ]);

        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'message' => 'Error al subir las imágenes: ' . $e->getMessage(),
                'accepted' => false
            ], 500);
        }
    }
}
