<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\Usuario;
use App\Helpers\JwtAuth;

class WSUsuarioController extends Controller
{
    public function login(Request $request) {
        $email = $request->input('email');
        $password = $request->input('password');

        $user = Usuario::where('email', $email)->first();

        if ($user && Hash::check($password, $user->password)) {
            $token = JwtAuth::encode(['sub' => $user->id, 'email' => $user->email, 'id_persona' => $user->id_persona, 'iat' => time(), 'exp' => time() + (60 * 60)]);
            return response()->json([
                'message' => 'Login successful',
                'accepted' => true,
                'token' => $token
            ]);
        }

        return response()->json([
            'message' => 'Login failed',
            'accepted' => false
        ]);
    }
}
