<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\VPersonaUsuario;
use App\Models\VAsignacion;
use App\Helpers\RolesEnum;

class AsignacionController extends Controller
{
    public function index()
    {
        $supervisores = VPersonaUsuario::where('id_rol', RolesEnum::SUPERVISOR->value)->get();
        $personas = VPersonaUsuario::where('id_rol', RolesEnum::TECNICO->value)->get(); //Solo obtengo los tecnicos instaladores
        $data = [
            'personas' => $personas,
            'supervisores' => $supervisores
        ];
        return view('dashboard.asignacion.index', $data);
    }
    
    public function list()
    {
        $asignaciones = VAsignacion::all();
        $data = [
            'asignaciones' => $asignaciones
        ];
        return view('dashboard.asignacion.list', $data);
    }
}
