<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Helpers\ApiResponse;
use App\Helpers\HttpCode;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Hash;
use App\Models\VMenuPrincipal;
use App\Models\Persona;
use App\Models\Menu;

class LoginController extends Controller
{
    /**
     * Muestra el formulario de login.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        //echo Hash::make('12345678');
        return view('sign-in');
    }

    /**
     * Gestiona la petición de autenticación.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Request $request)
    {
        $credentials = $request->validate([
            'email' => ['required', 'email'],
            'password' => ['required'],
        ]);

        if (Auth::attempt($credentials)) {
            $request->session()->regenerate();
            $usuario = Auth::user();
            // Ahora puedes obtener cualquier campo
            $id_rol = $usuario->id_rol;
            $id_persona = $usuario->id_persona;

            $menu = $this->menus($id_rol);
            //dd($menu);
            //exit;
            $data = Persona::where(['id'=>$id_persona])->first();
            //dd($data);
            $data_session = [
                                'status'=> true,
                                'paterno' => $data->paterno,
                                'materno' => $data->materno,
                                'nombre' => $data->nombre,
                                'id_persona' => $data->id_persona,
                                'nombre_rol' => $data->nombre_rol,
                                'id_rol' => $data->id_rol,
                                'fotografia' =>  $data->fotografia,
                                'menu'  => $menu
                            ];

            Session::put('data_session', $data_session);

            return ApiResponse::success(
                ['redirect' => url('/main')],
                'Login exitoso',
                HttpCode::OK
            );
        }

        return ApiResponse::successError(
                [],
                'Error de Username o Password',
                HttpCode::OK
            );
    }

    /**
     * Cierra la sesión del usuario.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy(Request $request)
    {
        Auth::logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/login');
    }
    private function menus($id_rol){
        $menuAll = [];
        //$modules = VMenuPrincipal::where('id_rol', $id_rol)->select('id_modulo','nombre_modulo')->distinct()->get();
        $modules = VMenuPrincipal::where('id_rol', $id_rol)->select('id_modulo','nombre_modulo')->distinct()->get();

        $arrayModules = [];
        foreach($modules as $m){
            $id_modulo = $m->id_modulo;

            $arrayModules = [
                'type' => 'section',
                'name' => $m->nombre_modulo,
            ];

            $data = VMenuPrincipal::where(['id_rol'=>$id_rol,'id_modulo'=>$id_modulo])->select('id_menu_principal','nombre_menu_principal')->distinct()->get();
            //dd(count($data));

            $menus = [];
            foreach($data as $d){

                $id_menu_principal = $d->id_menu_principal;

                $itemArray = [
                    'type' => 'accordion',
                    'name' => $d->nombre_menu_principal,
                    'icon' => 'dashboard',
                ];

                $data_menu = Menu::where(['id_menu_principal' => $id_menu_principal])->orderBy('orden', 'ASC')->get();

                $subitemArray = [];
                foreach($data_menu as $dm){
                    $url = url($dm->directorio);
                    $subitemArray[] = [
                        'name' => $dm->nombre,
                        'url' => $url,
                    ];
                }
                $itemArray['sub_items'] = $subitemArray;
                $menus[] = $itemArray;
            }
            $arrayModules['items'] = $menus;
            $menuAll[] = $arrayModules;
        }
        //exit;
        return $menuAll;
    }
}
