<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Helpers\PdfInforme;
use App\Models\HpInstalacion;
use App\Models\VAsignacionEquipo;
use App\Models\HpImagen;
use App\Models\Color;

class HpInformeController extends Controller
{
    public function informejob($id)
    {
        $colorCatalogo = Color::all();
        // Obtener datos de la instalación
        $instalacion = VAsignacionEquipo::where('id', $id)->first();
        // Crear instancia del PDF
        $pdf = new PdfInforme('HP+ Protokoll', 'Reporte Técnico de Trabajo de Campo', 'P', 'mm', 'A4', $id );
        
        // Agregar página
        $pdf->AddPage();

        $data = [
            [
                ['text' => 'Contratista General', 'bold' => true], 
                $instalacion->paterno.' '.$instalacion->materno.' '.$instalacion->nombre ?? 'N/A', 
                ['text' => 'Inspector de Obra', 'bold' => true], 
                $instalacion->paterno_supervisor.' '.$instalacion->materno_supervisor.' '.$instalacion->nombre_supervisor ?? 'N/A',
            ],
            [
                ['text' => 'Nombre del Proyecto', 'bold' => true], 
                $instalacion->nombre_proyecto ?? 'N/A', 
                ['text' => 'Grupo', 'bold' => true], 
                'N/A'
            ],
            [
                ['text' => 'Fecha', 'bold' => true], 
                $instalacion->fecha_finalizacion ?? 'N/A', 
                ['text' => 'ID', 'bold' => true], 
                $instalacion->id ?? 'N/A'
            ],
        ];
        $widths = [35, 60, 35, 60]; // Anchos de columnas en mm
        
        $pdf->agregarTabla2($data, $widths, 0);

        //-- --------------- segunda parte --------------------
        $direccion = ($instalacion->nombre_ubicacion ?? '') . ' CP: ' . ($instalacion->nombre_codigo_postal ?? '') . ' ' . ($instalacion->nombre_calle ?? '') . ' #' . ($instalacion->numero ?? '');
        $sdu = $instalacion->vivienda_unifamiliar ?? '0';
        $mdu = $instalacion->vivienda_multifamiliar ?? '0';
        $num = $instalacion->numero_unidades_residenciales ?? '0';

        $sdu = ($sdu == 1) ? '☑' : '☐';
        $mdu = ($mdu == 1) ? '☑' : '☐';

        $pdf->agregarCuadroInformacion($direccion, $sdu, $mdu, $num);

        // Obtener datos técnicos e imagen
        $datosTecnicos = HpInstalacion::find($id);
        //$imagen = HpImagen::where('id_hp_instalacion', $id)->first();
        $imgData = public_path('assets/images/instalacion_pdf.png');

        // Datos Columna 2 (A, B, C, D)
        $col2Data = [
            'A' => $datosTecnicos->A_ ?? '',
            'B' => $datosTecnicos->B_ ?? '',
            'C' => $datosTecnicos->Do_ ?? '', // Asumiendo Do_ es C
            'D' => $datosTecnicos->D_ ?? ''
        ];
        $asociacion = ''; $colorAsociacion = '';
        $microducto = ''; $colorMicroducto = '';

        if($datosTecnicos->id_color_asociacion != null){
            $colorAsociacion = Color::find($datosTecnicos->id_color_asociacion);
            $asociacion = $colorAsociacion->nombre;
            $colorAsociacion = $colorAsociacion->codigo_hexadecimal;
        }
        if($datosTecnicos->id_color_microducto != null){
            $colorMicroducto = Color::find($datosTecnicos->id_color_microducto);
            $microducto = $colorMicroducto->nombre;
            $colorMicroducto = $colorMicroducto->codigo_hexadecimal;
        }
        // Datos Columna 3 (Mixto)
        $col3Data = [
            ['text' => 'Coordenadas GPS del marcador de bola', 'bold' => true],
            ['text' => 'Especificadas en formato decimal WGS84', 'size' => 'small'],
            ['text' => $datosTecnicos->latitude.', '.$datosTecnicos->longitude, 'bold' => false],
            ['text' => 'Precisión', 'bold' => true],
            ['text' => $datosTecnicos->exactitud.' m'],
            ['text' => 'Código de color del microducto desviado', 'bold' => true], // Azul
            ['text' => 'Compuesto', 'size' => 'small', 'color' => [0, 102, 204]],
            ['text' => $asociacion, 'colorbolita' => $colorAsociacion, 'bolita' => true],
            ['text' => 'Microducto', 'size' => 'small', 'color' => [204, 0, 0]], // Rojo
            ['text' => $microducto, 'colorbolita' => $colorMicroducto, 'bolita' => true],
        ];

        $pdf->agregarSeccionDetalles($imgData, $col2Data, $col3Data);

        // --- GALERÍA DE IMÁGENES EXTRA ---
        $imagenesExtras = HpImagen::where('id_hp_instalacion', $id)
                                  ->where('estado', 'S')
                                  ->get();

        foreach ($imagenesExtras as $img) {
            $pdf->AddPage();
            
            // Título/Descripción de la imagen
            $tituloImagen = !empty($img->descripcion) ? $img->descripcion : 'Imagen sin descripción';
            $pdf->SetFont('helvetica', 'B', 14);
            $pdf->SetTextColor(33, 37, 41);
            $pdf->Cell(0, 10, $tituloImagen, 0, 1, 'L');
            $pdf->Ln(5);
            
            // Renderizar imagen
            $rutaImg = public_path('assets/images/jobs/' . $img->nombre_imagen);
            
            if (file_exists($rutaImg)) {
                // Calcular espacio disponible
                // Margen superior ya incluye header (70mm aprox)
                // Dejar margen inferior
                $maxW = $pdf->getPageWidth() - 30; // Margen izq + der (15+15)
                $maxH = $pdf->getPageHeight() - $pdf->GetY() - 20; // Espacio restante menos margen safe
                
                // Image($file, $x, $y, $w, $h, $type, $link, $align, $resize, $dpi, $palign, $ismask, $imgmask, $border, $fitbox)
                // Usar 'N' en el último parámetro para 'Next line' (aunque SetXY controla mejor) o simplemente coordenadas
                
                // Centrar imagen o ajustarla al ancho máximo manteniendo ratio
                $pdf->Image($rutaImg, 15, $pdf->GetY(), $maxW, $maxH, '', '', '', false, 300, '', false, false, 0, 'M');
            } else {
                $pdf->SetFont('helvetica', 'I', 12);
                $pdf->Cell(0, 10, 'Imagen no encontrada en el servidor: ' . $img->nombre_imagen, 0, 1, 'C');
            }
        }
        
        // Generar y descargar el PDF
        $nombreArchivo = 'informe_instalacion_' . $instalacion->id . '_' . date('Ymd_His') . '.pdf';
        
        return response()->streamDownload(function() use ($pdf) {
            $pdf->Output('I'); // I = inline, D = download
        }, $nombreArchivo, [
            'Content-Type' => 'application/pdf',
        ]);
    }
}
