<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\HpInstalacion;
use App\Models\Persona;
use App\Models\VCasa;
use App\Models\VListaAsignacion;
use App\Models\Color;
use App\Models\EstadoInstalacion;
use App\Models\TipoObjeto;
use App\Helpers\RolesEnum;
use Yajra\DataTables\Facades\DataTables;

class HpInstalacionController extends Controller
{
    public function index()
    {
        return view('dashboard.hpinstalacion.index');
    }

    public function edit($id)
    {
        return view('dashboard.hpinstalacion.edit', compact('id'));
    }

    public function indexjob()
    {
        $id_persona = auth()->user()->id_persona;
        $hpinstalacion = VListaAsignacion::where('id_persona', $id_persona)->get();
        $data = [
            'hpinstalacion' => $hpinstalacion
        ];
        return view('dashboard.hpinstalacionjob.index', $data);
    }

    public function editjob($id)
    {
        $colors = Color::all();
        $estado_instalacion = EstadoInstalacion::all();
        $tipo_objeto = TipoObjeto::all();
        $hpinstalacion = null;
        $urlList = '';
        if(auth()->user()->id_persona==RolesEnum::ADMINISTRADOR->value){
            $hpinstalacion = HpInstalacion::where(['id'=>$id])->first();
            $urlList = '/dashboard/hpinstalacion';
        }else{
            $hpinstalacion = HpInstalacion::where(['id'=>$id,'id_persona'=>auth()->user()->id_persona])->first();
            $urlList = '/dashboard/hpinstalacionjob';
        }
        if($hpinstalacion==null){
            return redirect()->route('hpinstalacion.index')->with('error', 'Instalación no encontrada.');
        }
        $persona = Persona::where('id', $hpinstalacion->id_persona)->first();
        $supervisor = Persona::where('id', $hpinstalacion->id_persona_supervisor)->first();
        $casas = VCasa::where('id_casa', $hpinstalacion->id_casa)->first();

        $data = [
            'urlList' => $urlList,
            'id' => $id,
            'hpinstalacion' => $hpinstalacion,
            'tipo_objeto' => $tipo_objeto,
            'persona' => $persona,
            'supervisor' => $supervisor,
            'casa' => $casas,
            'colors' => $colors,
            'estado_instalacion' => $estado_instalacion,
        ];
        return view('dashboard.hpinstalacionjob.edit', $data);
    }
}
