<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Role;
use App\Models\Proyecto;
use App\Models\Persona;
use App\Models\Usuario;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use App\Helpers\Utils;
use App\Helpers\RolesEnum;

class PersonaController extends Controller
{
    public function index()
    {
        return view('dashboard.persona.index');
    }

    public function create()
    {
        $roles = Role::where('id', RolesEnum::TECNICO)->get();
        $proyectos = Proyecto::all();
        $clave_inicial = Utils::generarClaveInicial();
        $password = Hash::make($clave_inicial);
        $data = [
            'roles' => $roles,
            'proyectos' => $proyectos,
            'clave_inicial' => $clave_inicial,
            'password' => $password
        ];
        return view('dashboard.persona.new', $data);
    }

    public function edit($id)
    {
        $persona = Persona::with('usuario')->findOrFail($id);
        $roles = Role::where('id', RolesEnum::TECNICO)->get();
        $proyectos = Proyecto::all();
        
        $data = [
            'persona' => $persona,
            'usuario' => $persona->usuario, // Puede ser null si no tiene usuario
            'roles' => $roles,
            'proyectos' => $proyectos
        ];

        return view('dashboard.persona.edit', $data);
    }
}
