<?php

namespace App\Http\Controllers;

use App\Models\Persona;
use App\Models\VPersonaUsuario;
use App\Helpers\RolesEnum;
use App\Helpers\Utils;
use App\Models\Role;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UsuarioController extends Controller
{
    public function index()
    {
        $usuarios = VPersonaUsuario::whereIn('id_rol', [RolesEnum::ADMINISTRADOR, RolesEnum::SUPERVISOR])->get(); //Admin OR Supervisor
        $data = [
            'usuarios' => $usuarios
        ];
        return view('dashboard.usuario.index', $data);
    }

    public function create(){
        $roles = Role::whereIn('id', [RolesEnum::ADMINISTRADOR, RolesEnum::SUPERVISOR])->get();
        $clave_inicial = Utils::generarClaveInicial();
        $password = Hash::make($clave_inicial);
        $data = [
            'roles' => $roles,
            'clave_inicial' => $clave_inicial,
            'password' => $password
        ];
        return view('dashboard.usuario.new', $data);
    }

    public function edit($id)
    {
        $persona = Persona::with('usuario')->findOrFail($id);
        $roles = Role::whereIn('id', [RolesEnum::ADMINISTRADOR, RolesEnum::SUPERVISOR])->get();
        
        $data = [
            'persona' => $persona,
            'usuario' => $persona->usuario, // Puede ser null si no tiene usuario
            'roles' => $roles
        ];

        return view('dashboard.usuario.edit', $data);
    }

    public function resetPassword($id){
        $persona = Persona::with('usuario')->findOrFail($id);
        $nueva_clave = Utils::generarClaveInicial();
        $password = Hash::make($nueva_clave);
        $data = [
            'nueva_clave' => $nueva_clave,
            'password' => $password,
            'persona' => $persona,
            'usuario' => $persona->usuario, // Puede ser null si no tiene usuario
        ];
        return view('dashboard.usuario.reset', $data);
    }
}
