<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Helpers\JwtAuth;

class VerifyJwtToken
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $token = $request->header('Authorization');

        if (!$token) {
            return response()->json(['error' => 'Token not provided'], 401);
        }

        // Remove 'Bearer ' if present
        if (str_starts_with($token, 'Bearer ')) {
            $token = substr($token, 7);
        }

        if (JwtAuth::verify($token)) {
            return $next($request);
        }

        return response()->json(['error' => 'Invalid or expired token'], 401);
    }
}
