<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Calle extends Model
{
    protected $table = 'calles';
    protected $primaryKey = 'id';
    public $timestamps = false;

    protected $fillable = [
        'id_codigo_postal',
        'nombre',
        'estado',
    ];

    public function codigoPostal()
    {
        return $this->belongsTo(CodigoPostal::class, 'id_codigo_postal', 'id');
    }

    public function casas()
    {
        return $this->hasMany(Casa::class, 'id_calle', 'id');
    }
}
