<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CodigoPostal extends Model
{
    protected $table = 'codigo_postal';
    protected $primaryKey = 'id';
    public $timestamps = false;

    protected $fillable = [
        'id_ubicacion',
        'nombre',
        'estado',
    ];

    public function ubicacion()
    {
        return $this->belongsTo(Ubicacion::class, 'id_ubicacion', 'id');
    }

    public function calles()
    {
        return $this->hasMany(Calle::class, 'id_codigo_postal', 'id');
    }
}
