<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HpImagen extends Model
{
    protected $table = 'hp_imagenes';
    protected $primaryKey = 'id';
    public $timestamps = false;

    // Campos que se pueden asignar masivamente
    protected $fillable = [
        'id_hp_instalacion',
        'nombre_imagen',
        'descripcion',
        'estado'
    ];

    /**
     * Relación con la instalación
     */
    public function instalacion()
    {
        return $this->belongsTo(HpInstalacion::class, 'id_hp_instalacion');
    }
}
