<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HpInstalacion extends Model
{
    protected $table = 'hp_instalacion';
    protected $primaryKey = 'id';
    public $timestamps = false;

    // Campos que se pueden asignar masivamente
    protected $fillable = [
        'id_casa',
        'id_persona',
        'id_persona_supervisor',
        'id_persona_asignacion',
        'id_tipo_objeto',
        'vivienda_unifamiliar',
        'vivienda_multifamiliar',
        'numero_unidades_residenciales',
        'A_',
        'B_',
        'Do_',
        'D_',
        'latitude',
        'longitude',
        'exactitud',
        'deteccion_manual',
        'id_color_asociacion',
        'id_color_microducto',
        'fecha_asignacion',
        'fecha_inicio',
        'fecha_finalizacion',
        'fecha_cancelacion',
        'id_estado_instalacion',
        'estado'
    ];

    /**
     * Relación con la casa
     */
    public function casa()
    {
        return $this->belongsTo(Casa::class, 'id_casa');
    }

    /**
     * Relación con la persona asignada (equipo)
     */
    public function persona()
    {
        return $this->belongsTo(Persona::class, 'id_persona');
    }

    /**
     * Relación con el supervisor
     */
    public function supervisor()
    {
        return $this->belongsTo(Persona::class, 'id_persona_supervisor');
    }
}
