<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Menu extends Model
{
    protected $table = 'menus';
    protected $primaryKey = 'id';
    public $timestamps = false;

    protected $fillable = [
        'id_menu_principal',
        'nombre',
        'directorio',
        'icono',
        'imagen',
        'color',
        'orden',
        'estado'
    ];

    /**
     * Relación: pertenece a un menú principal
     */
    public function menuPrincipal()
    {
        return $this->belongsTo(MenuPrincipal::class, 'id_menu_principal', 'id');
    }
}
