<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MenuPrincipal extends Model
{
    protected $table = 'menus_principales';
    protected $primaryKey = 'id';
    public $timestamps = false;

    protected $fillable = [
        'id_modulo',
        'nombre',
        'icono',
        'orden',
        'estado'
    ];

    /**
     * Relación: pertenece a un módulo
     */
    public function modulo()
    {
        return $this->belongsTo(Modulo::class, 'id_modulo', 'id');
    }

    /**
     * Relación: un menú principal tiene muchos submenús
     */
    public function menus()
    {
        return $this->hasMany(Menu::class, 'id_menu_principal', 'id');
    }

    /**
     * Relación: muchos roles asignados
     */
    public function roles()
    {
        return $this->belongsToMany(
            Role::class,
            'roles_menus_principales',
            'id_menu_principal',
            'id_rol'
        )->withPivot('fecha_asignacion', 'estado');
    }
}
