<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Modulo extends Model
{
    protected $table = 'modulos';
    protected $primaryKey = 'id';
    public $timestamps = false;

    protected $fillable = [
        'nombre',
        'estado'
    ];

    /**
     * Relación: un módulo tiene muchos menús principales
     */
    public function menusPrincipales()
    {
        return $this->hasMany(MenuPrincipal::class, 'id_modulo', 'id');
    }
}
