<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Persona extends Model
{
    protected $table = 'personas';
    protected $primaryKey = 'id';

    protected $fillable = [
        'id_proyecto',
        'dni',
        'paterno',
        'materno',
        'nombre',
        'nombre_corto',
        'Website',
        'Twitter',
        'fecha_nacimiento',
        'direccion',
        'telefono_celular',
        'telefono_fijo',
        'zona',
        'email',
        'fotografia',
        'estado'
    ];

    // RELACIONES
    public function proyecto()
    {
        return $this->belongsTo(Proyecto::class, 'id_proyecto', 'id');
    }

    public function usuario()
    {
        return $this->hasOne(Usuario::class, 'id_persona', 'id');
    }

    // =========================
    // MUTATORS (al guardar)
    // =========================

    // Capitalizar nombre completo
    public function setNombreAttribute($value)
    {
        $this->attributes['nombre'] = ucwords(strtolower($value));
    }

    public function setPaternoAttribute($value)
    {
        $this->attributes['paterno'] = ucwords(strtolower($value));
    }

    public function setMaternoAttribute($value)
    {
        $this->attributes['materno'] = ucwords(strtolower($value));
    }

    public function setNombreCortoAttribute($value)
    {
        $this->attributes['nombre_corto'] = ucwords(strtolower($value));
    }

    // Asegurar fotografía por defecto
    public function setFotografiaAttribute($value)
    {
        $this->attributes['fotografia'] = $value ?: 'default.jpg';
    }

    // =========================
    // ACCESSORS (al leer)
    // =========================

    // Fecha de nacimiento en formato dd/mm/yyyy
    public function getFechaNacimientoAttribute($value)
    {
        return $value ? \Carbon\Carbon::parse($value)->format('d/m/Y') : null;
    }

    // Nombre completo combinado
    public function getNombreCompletoAttribute()
    {
        return trim("{$this->nombre} {$this->paterno} {$this->materno}");
    }
}
