<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Proyecto extends Model
{
    protected $table = 'proyectos';
    protected $primaryKey = 'id';
    public $timestamps = false; // La tabla NO tiene created_at / updated_at

    protected $fillable = [
        'nombre',
        'direccion',
        'telefono',
        'email',
        'website',
        'logo_compania',
        'estado'
    ];

    // RELACIONES
    public function personas()
    {
        return $this->hasMany(Persona::class, 'id_proyecto', 'id');
    }
}
