<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    protected $table = 'roles';
    protected $primaryKey = 'id';
    public $timestamps = false;

    protected $fillable = [
        'nombre',
        'descripcion',
        'estado'
    ];

    /**
     * Relación: muchos menús principales asignados
     */
    public function menusPrincipales()
    {
        return $this->belongsToMany(
            MenuPrincipal::class,
            'roles_menus_principales',
            'id_rol',
            'id_menu_principal'
        )->withPivot('fecha_asignacion', 'estado');
    }
}
