<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Usuario extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $table = 'usuarios';
    protected $primaryKey = 'id';

    /**
     * Los atributos que se pueden asignar masivamente.
     */
    protected $fillable = [
        'id_persona',
        'id_rol',
        'username',
        'email',
        'clave_inicial',
        'password',
        'email_verified_at',
        'remember_token',
        'ultimo_acceso',
        'intentos_fallidos',
        'bloqueado_hasta',
        'debe_cambiar_password',
        'password_temporal',
        'estado'
    ];

    //protected $hidden = ['password'];

    /**
     * Los atributos que deben ocultarse en arrays.
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Tipos de datos nativos.
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'ultimo_acceso'     => 'datetime',
        'bloqueado_hasta'   => 'datetime',
        'debe_cambiar_password' => 'boolean',
        'password_temporal' => 'boolean',
    ];

    /**
     * Relación con personas (usuario pertenece a una persona).
     */
    public function persona()
    {
        return $this->belongsTo(Persona::class, 'id_persona');
    }

    public function rol()
    {
        return $this->belongsTo(Role::class, 'id_rol');
    }

}
