(function ($) {
    "use strict";

    $.showAlert = function (message, options = {}) {
        const settings = $.extend({
            type: 'success',       // success, error, info, warning
            duration: 5000,        // duración en ms
            position: 'top-right'  // top-right, top-left, bottom-right, bottom-left
        }, options);

        // Colores e iconos según tipo
        const typeConfig = {
            success: { bg: 'bg-green-100 border-green-400 text-green-700', icon: 'check_circle' },
            error: { bg: 'bg-red-100 border-red-400 text-red-700', icon: 'error' },
            info: { bg: 'bg-blue-100 border-blue-400 text-blue-700', icon: 'info' },
            warning: { bg: 'bg-yellow-100 border-yellow-400 text-yellow-700', icon: 'warning' }
        };

        const bgColor = typeConfig[settings.type].bg;
        const icon = typeConfig[settings.type].icon;

        // Crear toast
        const toast = $(`
            <div class="toast ${bgColor} px-4 py-3 rounded-md border flex items-center shadow-lg opacity-0 transition-opacity duration-300" role="alert">
                <i class="material-symbols-outlined mr-2 text-lg">${icon}</i>
                <span>${message}</span>
                <button type="button" class="ml-auto text-lg hover:opacity-75">
                    <i class="material-symbols-outlined">close</i>
                </button>
            </div>
        `);

        // Cerrar al hacer click
        toast.find('button').on('click', function () {
            $(this).parent().fadeOut(function () { $(this).remove(); });
        });

        // Crear contenedor si no existe
        const containerId = 'toast-container-' + settings.position.replace('-', '');
        if ($('#' + containerId).length === 0) {
            const posClasses = {
                'top-right': 'top-5 right-5',
                'top-left': 'top-5 left-5',
                'bottom-right': 'bottom-5 right-5',
                'bottom-left': 'bottom-5 left-5'
            };
            $('body').append(`<div id="${containerId}" class="fixed z-50 flex flex-col gap-2 ${posClasses[settings.position]}"></div>`);
        }

        // Agregar toast al contenedor
        $('#' + containerId).append(toast);
        toast.animate({ opacity: 1 }, 300);

        // Auto-ocultar
        setTimeout(function () {
            toast.fadeOut(function () { $(this).remove(); });
        }, settings.duration);
    };

    $.showSimpleToast = function (message, type = 'success', duration = 5000) {
        const bgColor = type === 'success'
            ? 'bg-green-100 border-green-400 text-green-700'
            : 'bg-red-100 border-red-400 text-red-700';
        const icon = type === 'success' ? 'check_circle' : 'error';

        const toast = $(`
            <div class="toast ${bgColor} px-4 py-3 rounded-md border flex items-center shadow-lg" role="alert" style="display:none;">
                <i class="material-symbols-outlined mr-2 text-lg">${icon}</i>
                <span>${message}</span>
                <button type="button" class="ml-auto text-lg hover:opacity-75">
                    <i class="material-symbols-outlined">close</i>
                </button>
            </div>
        `);

        // Cerrar al hacer click
        toast.find('button').on('click', function () {
            $(this).parent().fadeOut(function () { $(this).remove(); });
        });

        // Agregar al contenedor y mostrar
        // Asegurarse de que existe el contenedor
        if ($('#toast-container').length === 0) {
            $('body').append('<div id="toast-container" class="fixed top-5 right-5 z-50 flex flex-col gap-2"></div>');
        }

        $('#toast-container').append(toast);
        toast.fadeIn();

        // Auto-ocultar
        setTimeout(function () {
            toast.fadeOut(function () { $(this).remove(); });
        }, duration);
    };
})(jQuery);