@extends('master')

@section('stylesCSS')
    <!-- DataTableTailwind 2.3.5 -->
    <link rel="stylesheet" href="https://cdn.datatables.net/2.3.5/css/dataTables.tailwindcss.css">
    <style>
        /* Custom scrollbar for table container if needed */
        .custom-scrollbar::-webkit-scrollbar {
            height: 8px;
        }
        .custom-scrollbar::-webkit-scrollbar-track {
            background: #f1f1f1; 
            border-radius: 4px;
        }
        .custom-scrollbar::-webkit-scrollbar-thumb {
            background: #cbd5e1; 
            border-radius: 4px;
        }
        .custom-scrollbar::-webkit-scrollbar-thumb:hover {
            background: #94a3b8; 
        }
        
        /* Elegant Table Stying Overrides */
        table.dataTable thead th {
            padding-top: 0.5rem;
            padding-bottom: 0.5rem;
            color: #475569; /* Slate 600 */
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            font-size: 0.75rem;
            background-color: #f8fafc; /* Slate 50 */
            border-bottom: 2px solid #e2e8f0;
        }
        table.dataTable tbody td {
            padding-top: 0.5rem;
            padding-bottom: 0.5rem;
            border-bottom: 1px solid #f1f5f9;
            color: #334155; /* Slate 700 */
            font-size: 0.8rem;
        }
        table.dataTable tbody tr:hover {
            background-color: #f8fafc; /* Slate 50 */
            transition: background-color 0.2s ease;
        }
    </style>
@endsection

@section('headerContent')
<div class="flex flex-col gap-1">
    <h5 class="text-2xl font-bold text-slate-800 tracking-tight">
        Gestión de Asignaciones
    </h5>
    <nav class="flex" aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-2 rtl:space-x-reverse">
            <li class="inline-flex items-center">
                <a href="/main" class="inline-flex items-center text-sm font-medium text-slate-500 hover:text-blue-600 transition-colors">
                    <span class="material-symbols-outlined text-lg mr-1">home</span>
                    Dashboard
                </a>
            </li>
            <li aria-current="page">
                <div class="flex items-center">
                    <span class="material-symbols-outlined text-slate-400 mx-1">chevron_right</span>
                    <span class="ml-1 text-sm font-medium text-slate-700 md:ml-2">Asignaciones</span>
                </div>
            </li>
        </ol>
    </nav>
</div>
@endsection

@section('bodyContent')
<div class="w-full max-w-7xl mx-auto px-4 pb-12 pt-6">
    
    <div class="grid grid-cols-1 lg:grid-cols-12 gap-8">
        
        <!-- CARD IZQUIERDA: FORMULARIO -->
        <div class="lg:col-span-4 space-y-6">
            <div class="bg-white rounded-3xl shadow-xl shadow-slate-200/50 border border-slate-100 overflow-hidden relative">
                <!-- Header Decorativo -->
                <div class="absolute top-0 left-0 w-full h-2 bg-gradient-to-r from-blue-500 to-indigo-600"></div>
                
                <div class="p-8">
                    <div class="flex items-center gap-3 mb-8">
                        <div class="w-12 h-12 rounded-2xl bg-blue-50 flex items-center justify-center text-blue-600 shadow-sm">
                            <span class="material-symbols-outlined text-2xl">add_task</span>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-slate-800">Nueva Asignación</h3>
                            <p class="text-sm text-slate-500 font-medium">Complete los detalles de instalación</p>
                        </div>
                    </div>

                    <form id="asignacion-form" class="space-y-5">
                        @csrf
                        
                        <!-- 1. Ubicación -->
                        <div class="group">
                            <label for="id_ubicacion" class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-2 ml-1">Ubicación</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-slate-400 group-focus-within:text-blue-500 transition-colors">location_on</span>
                                </div>
                                <select id="id_ubicacion" name="id_ubicacion" required
                                    class="block w-full pl-10 pr-4 py-3 bg-slate-50 border-0 text-slate-700 rounded-xl ring-1 ring-slate-200 focus:ring-2 focus:ring-blue-500 focus:bg-white transition-all duration-200 text-sm appearance-none cursor-pointer hover:bg-slate-100">
                                    <option value="">Seleccione ubicación...</option>
                                </select>
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-slate-400 text-sm">expand_more</span>
                                </div>
                            </div>
                        </div>

                        <!-- 2. Código Postal -->
                        <div class="group">
                            <label for="id_codigo_postal" class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-2 ml-1">Código Postal</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-slate-400 group-focus-within:text-blue-500 transition-colors">mark_as_unread</span>
                                </div>
                                <select id="id_codigo_postal" name="id_codigo_postal" required disabled
                                    class="block w-full pl-10 pr-4 py-3 bg-slate-50 border-0 text-slate-700 rounded-xl ring-1 ring-slate-200 focus:ring-2 focus:ring-blue-500 focus:bg-white transition-all duration-200 text-sm appearance-none disabled:opacity-60 disabled:cursor-not-allowed">
                                    <option value="">Seleccione código postal...</option>
                                </select>
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-slate-400 text-sm">expand_more</span>
                                </div>
                            </div>
                        </div>

                        <!-- 3. Calle -->
                        <div class="group">
                            <label for="id_calle" class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-2 ml-1">Calle</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-slate-400 group-focus-within:text-blue-500 transition-colors">add_road</span>
                                </div>
                                <select id="id_calle" name="id_calle" required disabled
                                    class="block w-full pl-10 pr-4 py-3 bg-slate-50 border-0 text-slate-700 rounded-xl ring-1 ring-slate-200 focus:ring-2 focus:ring-blue-500 focus:bg-white transition-all duration-200 text-sm appearance-none disabled:opacity-60 disabled:cursor-not-allowed">
                                    <option value="">Seleccione calle...</option>
                                </select>
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-slate-400 text-sm">expand_more</span>
                                </div>
                            </div>
                        </div>

                        <!-- 4. Casa -->
                        <div class="group">
                            <label for="id_casa" class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-2 ml-1">Casa / Número</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-slate-400 group-focus-within:text-blue-500 transition-colors">home</span>
                                </div>
                                <select id="id_casa" name="id_casa" required disabled
                                    class="block w-full pl-10 pr-4 py-3 bg-slate-50 border-0 text-slate-700 rounded-xl ring-1 ring-slate-200 focus:ring-2 focus:ring-blue-500 focus:bg-white transition-all duration-200 text-sm appearance-none disabled:opacity-60 disabled:cursor-not-allowed">
                                    <option value="">Seleccione casa...</option>
                                </select>
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-slate-400 text-sm">expand_more</span>
                                </div>
                            </div>
                        </div>

                        <div class="border-t border-slate-100 my-4"></div>

                        <!-- Equipo -->
                        <div class="group">
                            <label for="id_persona" class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-2 ml-1">Equipo de Instalación</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-slate-400 group-focus-within:text-indigo-500 transition-colors">engineering</span>
                                </div>
                                <select id="id_persona" name="id_persona" required
                                    class="block w-full pl-10 pr-4 py-3 bg-slate-50 border-0 text-slate-700 rounded-xl ring-1 ring-slate-200 focus:ring-2 focus:ring-indigo-500 focus:bg-white transition-all duration-200 text-sm appearance-none cursor-pointer hover:bg-slate-100">
                                    <option value="">Seleccione equipo...</option>
                                    @foreach ($personas as $persona)
                                        <option value="{{ $persona->id_persona }}">{{ $persona->paterno }} {{ $persona->materno }}, {{ $persona->nombre }}</option>
                                    @endforeach
                                </select>
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-slate-400 text-sm">expand_more</span>
                                </div>
                            </div>
                        </div>

                        <!-- Supervisor -->
                        <div class="group">
                            <label for="id_persona_supervisor" class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-2 ml-1">Supervisor Responsable</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-slate-400 group-focus-within:text-indigo-500 transition-colors">assignment_ind</span>
                                </div>
                                <select id="id_persona_supervisor" name="id_persona_supervisor" required
                                    class="block w-full pl-10 pr-4 py-3 bg-slate-50 border-0 text-slate-700 rounded-xl ring-1 ring-slate-200 focus:ring-2 focus:ring-indigo-500 focus:bg-white transition-all duration-200 text-sm appearance-none cursor-pointer hover:bg-slate-100">
                                    <option value="">Seleccione supervisor...</option>
                                    @foreach ($supervisores as $supervisor)
                                        <option value="{{ $supervisor->id_persona }}">{{ $supervisor->paterno }} {{ $supervisor->materno }}, {{ $supervisor->nombre }}</option>
                                    @endforeach
                                </select>
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-slate-400 text-sm">expand_more</span>
                                </div>
                            </div>
                        </div>

                        <div class="pt-4">
                            <button type="submit" id="btn-asignar"
                                class="w-full py-3.5 px-6 bg-gradient-to-r from-blue-400 to-blue-600 
                                    hover:from-blue-500 hover:to-blue-700 
                                    text-white font-bold rounded-2xl shadow-lg shadow-blue-400/30 
                                    transform transition-all duration-200 
                                    hover:-translate-y-0.5 active:translate-y-0 
                                    flex items-center justify-center gap-2 group">
                                    
                                <span class="material-symbols-outlined group-hover:scale-110 transition-transform"
                                    style="font-variation-settings: 'wght' 200;">
                                    save_as
                                </span>
                                Guardar Asignación
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- CARD DERECHA: TABLA -->
        <div class="lg:col-span-8">
            <div class="bg-white rounded-3xl shadow-xl shadow-slate-200/50 border border-slate-100 overflow-hidden h-full flex flex-col">
                 <!-- Header Tabla -->
                 <div class="p-6 border-b border-slate-100 bg-slate-50/50 flex flex-col sm:flex-row sm:items-center justify-between gap-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 rounded-xl bg-indigo-50 flex items-center justify-center text-indigo-600">
                            <span class="material-symbols-outlined">table_view</span>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-slate-800">Registros del Día</h3>
                            <p class="text-xs text-slate-500">Filtrar por fecha de asignación</p>
                        </div>
                    </div>

                    <div class="relative group">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <span class="material-symbols-outlined text-slate-400 group-focus-within:text-blue-500 transition-colors">calendar_month</span>
                        </div>
                        <input type="date" id="filtro_fecha" value="{{ date('Y-m-d') }}"
                            class="pl-10 pr-3 py-2 bg-white border-0 ring-1 ring-slate-200 rounded-lg text-sm text-slate-600 focus:ring-2 focus:ring-blue-500 outline-none shadow-sm transition-all" />
                    </div>
                </div>

                <div class="p-0 flex-1 overflow-hidden">
                    <div class="overflow-x-auto h-full custom-scrollbar">
                        <table id="tabla-asignaciones" class="w-full text-left border-collapse">
                            <thead>
                                <tr>
                                    <th class="px-3 py-2">Dirección</th>
                                    <th class="px-3 py-2">Equipo</th>
                                    <th class="px-3 py-2">Fecha</th>
                                    <th class="px-3 py-2 text-center">Acciones</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-slate-100">
                                <!-- DataTables Content -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>

<!-- MODAL VER DETALLES (Elegant Glass) -->
<div id="modal-ver" class="fixed inset-0 z-50 hidden overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    
    <!-- Backdrop Blur -->
    <div class="fixed inset-0 bg-black/50 bg-opacity-50 backdrop-blur-sm transition-opacity" aria-hidden="true" onclick="closeModal()"></div>

    <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:block sm:p-0">
        <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
        
        <div class="relative inline-block align-bottom bg-white rounded-3xl text-left overflow-hidden shadow-2xl transform transition-all sm:my-8 sm:align-middle sm:max-w-md sm:w-full border border-white/50 z-50">
            <!-- Header Modal -->
            <div class="bg-gradient-to-r from-blue-300 to-blue-500 px-6 py-4 flex items-center justify-between rounded-t-lg">
                <h3 class="text-white font-bold text-lg flex items-center gap-2">
                    <span class="material-symbols-outlined" style="font-variation-settings: 'wght' 200;">info</span>
                    Detalles de Asignación
                </h3>
                <button type="button" onclick="closeModal()" class="text-white/80 hover:text-white transition-colors">
                    <span class="material-symbols-outlined" style="font-variation-settings: 'wght' 200;">close</span>
                </button>
            </div>

            <div class="p-6">
                <!-- Content -->
                 <div id="modal-content" class="space-y-4">
                    <div class="flex flex-col items-center justify-center py-8">
                        <span class="material-symbols-outlined text-4xl text-blue-500 animate-spin">refresh</span>
                        <p class="text-sm text-slate-500 mt-2">Cargando información...</p>
                    </div>
                 </div>
            </div>

            <!-- Footer -->
            <div class="bg-slate-50 px-6 py-4 flex justify-end">
                <button type="button" 
                    class="px-4 py-2 bg-white border border-slate-200 rounded-xl text-slate-700 font-semibold hover:bg-slate-50 hover:border-slate-300 transition-all shadow-sm flex items-center gap-2"
                    onclick="closeModal()">
                    <span class="material-symbols-outlined text-sm">close</span>    
                    Cerrar
                </button>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scriptsJS')
<script src="{{ asset('public/js/CRUD.js') }}"></script>
<!-- Scripts DataTables 2.3.5 -->
<script src="https://cdn.datatables.net/2.3.5/js/dataTables.js"></script>
<script src="https://cdn.datatables.net/2.3.5/js/dataTables.tailwindcss.js"></script>

<script>
$(document).ready(function() {
    
    // --- LÓGICA DE DROPDOWNS DEPENDIENTES ---
    
    function loadOptions(url, targetSelect, placeholder, paramName, paramValue) {
        targetSelect.html(`<option value="">Cargando...</option>`);
        targetSelect.prop('disabled', true);
        
        let data = {};
        if (paramName && paramValue) {
            data[paramName] = paramValue;
        }

        $.ajax({
            url: url,
            type: 'GET',
            data: data,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    let options = `<option value="">${placeholder}</option>`;
                    response.data.forEach(function(item) {
                        let text = item.nombre || item.numero; 
                        options += `<option value="${item.id}">${text}</option>`;
                    });
                    targetSelect.html(options);
                    targetSelect.prop('disabled', false);
                } else {
                    targetSelect.html(`<option value="">Error al cargar</option>`);
                }
            },
            error: function(xhr) {
                targetSelect.html(`<option value="">Error de conexión</option>`);
            }
        });
    }

    // 1. Cargar Ubicaciones
    loadOptions("{{ url('/rubicacion') }}", $('#id_ubicacion'), 'Seleccione ubicación...');

    // 2. Ubicación -> CP
    $('#id_ubicacion').on('change', function() {
        const ubicacionId = $(this).val();
        $('#id_codigo_postal').html('<option value="">Seleccione código postal...</option>').prop('disabled', true);
        $('#id_calle').html('<option value="">Seleccione calle...</option>').prop('disabled', true);
        $('#id_casa').html('<option value="">Seleccione casa...</option>').prop('disabled', true);

        if (ubicacionId) {
            loadOptions("{{ url('/rcodigopostal') }}", $('#id_codigo_postal'), 'Seleccione código postal...', 'id_ubicacion', ubicacionId);
        }
    });

    // 3. CP -> Calle
    $('#id_codigo_postal').on('change', function() {
        const codigoPostalId = $(this).val();
        $('#id_calle').html('<option value="">Seleccione calle...</option>').prop('disabled', true);
        $('#id_casa').html('<option value="">Seleccione casa...</option>').prop('disabled', true);

        if (codigoPostalId) {
            loadOptions("{{ url('/rcalle') }}", $('#id_calle'), 'Seleccione calle...', 'id_codigo_postal', codigoPostalId);
        }
    });

    // 4. Calle -> Casa
    $('#id_calle').on('change', function() {
        const calleId = $(this).val();
        $('#id_casa').html('<option value="">Seleccione casa...</option>').prop('disabled', true);
        if (calleId) {
            loadOptions("{{ url('/rcasa') }}", $('#id_casa'), 'Seleccione casa...', 'id_calle', calleId);
        }
    });


    // --- SUBMIT FORMULARIO ---
    $('#asignacion-form').on('submit', function(e) {
        e.preventDefault();
        
        const id_casa = $('#id_casa').val();
        const id_persona = $('#id_persona').val();
        const id_persona_supervisor = $('#id_persona_supervisor').val();

        if (!id_casa || !id_persona || !id_persona_supervisor) {
            $.showSimpleToast('Complete todos los campos requeridos.', 'error', 3000);
            return;
        }

        const submitBtn = $('#btn-asignar');
        const originalContent = submitBtn.html();
        submitBtn.prop('disabled', true).html('<span class="material-symbols-outlined animate-spin">refresh</span> Guardando...');

        let formData = {
            id_casa: id_casa,
            id_persona: id_persona,
            id_persona_supervisor: id_persona_supervisor
        };

        CRUD.create("{{ route('rhpinstalacion.store') }}", formData)
            .done(function(response) {
                if (response.success) {
                    $.showSimpleToast('¡Asignación creada exitosamente!', 'success', 4000);
                    table.ajax.reload();
                    $('#id_casa').val(''); // Reset solo casa
                } else {
                    $.showSimpleToast('Error: ' + (response.message || 'Desconocido'), 'error');
                }
            })
            .fail(function(xhr) {
                let msg = xhr.responseJSON && xhr.responseJSON.message ? xhr.responseJSON.message : 'Error de conexión';
                $.showSimpleToast(msg, 'error');
            })
            .always(function() {
                submitBtn.prop('disabled', false).html(originalContent);
            });
    });


    // --- DATATABLE ---
    let table = $('#tabla-asignaciones').DataTable({
        processing: true,
        serverSide: true, 
        ajax: {
            url: "{{ url('rhpinstalacion/getByDate') }}",
            data: function (d) {
                d.fecha = $('#filtro_fecha').val();
            }
        },
        columns: [
            { 
                data: 'direccion', 
                name: 'direccion', 
                orderable: false, 
                searchable: false,
                render: function(data, type, row) {
                    return data;
                }
            },
            { 
                data: 'equipo', 
                name: 'equipo', 
                orderable: false, 
                searchable: false,
                render: function(data) {
                    return data;
                } 
            },
            { 
                data: 'fecha_asignacion', 
                name: 'fecha_asignacion',
                render: function(data) {
                    if(!data) return '-';
                    return `<span class="px-2 py-1 rounded-md bg-slate-100 text-slate-600 text-xs font-semibold tracking-wide">${data}</span>`;
                }
            },
            { data: 'action', name: 'action', orderable: false, searchable: false, className: 'text-center' }
        ],
        order: [[3, 'desc']], 
        dom: '<"flex flex-col md:flex-row justify-between items-center p-4 gap-4"lf>rt<"flex flex-col md:flex-row justify-between items-center p-4 gap-4"ip>',
        pageLength: 8,
        initComplete: function () {
            // Personalizacion de controles DT
            const wrapper = this.api().table().container().closest('.dataTables_wrapper');
            $(wrapper).find('div.dataTables_filter input')
                .addClass('pl-8 pr-4 py-2 border border-slate-200 rounded-lg text-sm focus:ring-2 focus:ring-blue-500 transition-shadow outline-none')
                .attr('placeholder', 'Buscar...');
            $(wrapper).find('div.dataTables_length select')
                .addClass('pl-3 pr-8 py-2 border border-slate-200 rounded-lg text-sm focus:ring-2 focus:ring-blue-500 outline-none');
        },
        drawCallback: function() {
            // Estilizar paginación
             $('.dataTables_paginate .paginate_button').addClass('px-3 py-1 bg-white border border-slate-200 text-slate-600 hover:bg-slate-50 hover:text-blue-600 rounded-md mx-1 text-sm transition-colors');
             $('.dataTables_paginate .paginate_button.current').addClass('!bg-blue-600 !text-white !border-blue-600');
             
             // Estilo Compacto celdas
             $('#tabla-asignaciones tbody tr td').addClass('py-2 px-3 border-b border-gray-100 whitespace-nowrap text-xs');
        }
    });

    $('#filtro_fecha').on('change', function() {
        table.ajax.reload();
    });

    // --- ACCIONES MODAL ---
    $('#tabla-asignaciones tbody').on('click', '.btn-ver', function(e) {
        e.preventDefault();
        let btn = $(this).closest('.btn-ver');
        let id = btn.data('id');
        if (!id) return;

        $('#modal-ver').removeClass('hidden');
        $('#modal-content').html(`
            <div class="flex flex-col items-center justify-center py-6">
                <span class="material-symbols-outlined text-4xl text-blue-500 animate-spin">refresh</span>
            </div>
        `);

        $.ajax({
            url: "{{ url('rhpinstalacion') }}/getInstalacionById/" + id, 
            type: 'GET',
            success: function(response) {
                if(response.success) {
                    let d = response.data;

                    let content = `
                        <div class="grid grid-cols-1 gap-4">
                            <!-- Item -->
                            <div class="flex items-start gap-4 p-3 bg-slate-50 rounded-xl border border-slate-100">
                                <div class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center text-blue-600 flex-shrink-0">
                                    <span class="material-symbols-outlined">home</span>
                                </div>
                                <div>
                                    <p class="text-xs font-bold text-slate-500 uppercase tracking-wide">Ubicación</p>
                                    <p class="text-slate-800 font-medium">${d.nombre_ubicacion} CP: ${d.nombre_codigo_postal} ${d.nombre_calle} # ${d.numero}</p>
                                </div>
                            </div>
                            
                            <!-- Item -->
                            <div class="flex items-start gap-4 p-3 bg-slate-50 rounded-xl border border-slate-100">
                                <div class="w-10 h-10 rounded-full bg-indigo-100 flex items-center justify-center text-indigo-600 flex-shrink-0">
                                    <span class="material-symbols-outlined">group</span>
                                </div>
                                <div>
                                    <p class="text-xs font-bold text-slate-500 uppercase tracking-wide">Equipo</p>
                                    <p class="text-slate-800 font-medium">${d.paterno} ${d.materno} ${d.nombre_persona}</p>
                                </div>
                            </div>

                             <!-- Item -->
                            <div class="flex items-start gap-4 p-3 bg-slate-50 rounded-xl border border-slate-100">
                                <div class="w-10 h-10 rounded-full bg-emerald-100 flex items-center justify-center text-emerald-600 flex-shrink-0">
                                    <span class="material-symbols-outlined">person_check</span>
                                </div>
                                <div>
                                    <p class="text-xs font-bold text-slate-500 uppercase tracking-wide">Supervisor</p>
                                    <p class="text-slate-800 font-medium">${d.paterno_supervisor} ${d.materno_supervisor} ${d.nombre_supervisor}</p>
                                </div>
                            </div>

                             <!-- Item -->
                            <div class="flex items-start gap-4 p-3 bg-slate-50 rounded-xl border border-slate-100">
                                <div class="w-10 h-10 rounded-full bg-amber-100 flex items-center justify-center text-amber-600 flex-shrink-0">
                                    <span class="material-symbols-outlined">event</span>
                                </div>
                                <div>
                                    <p class="text-xs font-bold text-slate-500 uppercase tracking-wide">Fecha Asignación</p>
                                    <p class="text-slate-800 font-medium">${d.fecha_asignacion}</p>
                                </div>
                            </div>
                        </div>
                    `;
                    $('#modal-content').html(content);
                } else {
                    $('#modal-content').html('<p class="text-red-500 text-center">No se pudo cargar la información</p>');
                }
            },
            error: function() {
                $('#modal-content').html('<p class="text-red-500 text-center">Error al conectar con el servidor</p>');
            }
        });
    });

    // Eliminar con SweetAlert styled
    $('#tabla-asignaciones tbody').on('click', '.btn-eliminar', function(e) {
        e.preventDefault();
        let btn = $(this).closest('.btn-eliminar');
        let id = btn.data('id');
        
        Swal.fire({
            title: '¿Eliminar Asignación?',
            text: "Esta acción no se puede deshacer.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#4f46e5', // Indigo-600
            cancelButtonColor: '#94a3b8',  // Slate-400
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
            customClass: {
                popup: 'rounded-2xl',
                confirmButton: 'px-6 py-2.5 rounded-xl font-bold',
                cancelButton: 'px-6 py-2.5 rounded-xl font-medium'
            }
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    title: 'Procesando...',
                    allowOutsideClick: false,
                    didOpen: () => Swal.showLoading(),
                    customClass: { popup: 'rounded-2xl' }
                });
                CRUD.delete("{{ url('/rhpinstalacion') }}", id)
                    .then(function(res) {
                        if(res.success) {
                            table.ajax.reload();
                            Swal.fire({
                                icon: 'success',
                                title: 'Eliminado',
                                text: res.message,
                                customClass: { popup: 'rounded-2xl' }
                            });
                        }
                    })
                    .fail(function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'No se pudo eliminar el registro.',
                            customClass: { popup: 'rounded-2xl' }
                        });
                    });
            }
        });
    });

    window.closeModal = function() {
        $('#modal-ver').addClass('hidden');
    }
});
</script>
@endsection
