@extends('master')

@section('stylesCSS')

<style>
    .filter-dropdown {
        display: none;
        position: absolute;
        background-color: white;
        border: 1px solid #d1d5db;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        z-index: 50;
        min-width: 220px;
        padding-top: 0.5rem;
        border-radius: 0.375rem;
        flex-direction: column;
        max-height: 350px;
    }
    .filter-dropdown.active {
        display: flex;
    }
    .filter-option {
        display: flex;
        align-items: center;
        padding: 0.25rem 0.5rem;
        cursor: pointer;
    }
    .filter-option:hover {
        background-color: #f3f4f6;
    }
    .filter-icon {
        cursor: pointer;
        margin-left: 0.5rem;
        color: #9ca3af;
        font-size: 0.8rem;
    }
    .filter-icon:hover {
        color: #4b5563;
    }
    .custom-scrollbar::-webkit-scrollbar {
        width: 6px;
    }
    .custom-scrollbar::-webkit-scrollbar-track {
        background: #f1f1f1; 
    }
    .custom-scrollbar::-webkit-scrollbar-thumb {
        background: #c1c1c1; 
        border-radius: 3px;
    }
    .custom-scrollbar::-webkit-scrollbar-thumb:hover {
        background: #a8a8a8; 
    }
    th.filtered .filter-icon {
        color: #2563eb;
        opacity: 1;
    }
    th.filtered {
        background-color: #eff6ff;
    }
</style>
@endsection

@section('headerContent')
<h5 class="!mb-0">
    Gestión de Asignaciones
</h5>
<ol class="breadcrumb mt-[12px] md:mt-0">
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        <a href="/main" class="inline-block relative ltr:pl-[22px] rtl:pr-[22px] transition-all hover:text-primary-500">
            <i class="material-symbols-outlined absolute ltr:left-0 rtl:right-0 !text-lg -mt-px text-primary-500 top-1/2 -translate-y-1/2">home</i>
            Dashboard
        </a>
    </li>
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        Asignaciones
    </li>
</ol>
@endsection

@section('titleContent')
<h3 class="!mb-0">
    Lista de asignaciones de instalaciones
</h3>
@endsection

@section('bodyContent')
<div class="max-w-full mx-auto bg-white p-6 rounded-lg shadow-md">
    <p class="mb-4 text-gray-600">Click en el ícono de filtro <span class="text-gray-400">▼</span> en los encabezados para filtrar columnas. Click en el texto del encabezado para ordenar.</p>

    <div class="overflow-x-auto relative">
        <table id="excel-table" class="min-w-full divide-y divide-gray-200 border">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider relative group cursor-pointer hover:bg-gray-100 transition-colors">
                        <div class="flex items-center justify-between">
                            <span>Ubicación</span>
                            <span class="filter-icon" data-col="0">▼</span>
                        </div>
                    </th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider relative group cursor-pointer hover:bg-gray-100 transition-colors">
                        <div class="flex items-center justify-between">
                            <span>Código Postal</span>
                            <span class="filter-icon" data-col="1">▼</span>
                        </div>
                    </th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider relative group cursor-pointer hover:bg-gray-100 transition-colors">
                        <div class="flex items-center justify-between">
                            <span>Calle</span>
                            <span class="filter-icon" data-col="2">▼</span>
                        </div>
                    </th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider relative group cursor-pointer hover:bg-gray-100 transition-colors">
                        <div class="flex items-center justify-between">
                            <span>Número</span>
                            <span class="filter-icon" data-col="3">▼</span>
                        </div>
                    </th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider relative group cursor-pointer hover:bg-gray-100 transition-colors">
                        <div class="flex items-center justify-between">
                            <span>Estado</span>
                            <span class="filter-icon" data-col="4">▼</span>
                        </div>
                    </th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider relative group cursor-pointer hover:bg-gray-100 transition-colors">
                        <div class="flex items-center justify-between">
                            <span>Equipo</span>
                            <span class="filter-icon" data-col="5">▼</span>
                        </div>
                    </th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @foreach($asignaciones as $asignacion)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $asignacion->nombre_ubicacion ?? 'N/A' }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $asignacion->nombre_codigo_postal ?? 'N/A' }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $asignacion->nombre_calle ?? 'N/A' }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $asignacion->numero ?? 'N/A' }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <span class="px-3 py-1 text-xs font-medium rounded-full 
                            @if($asignacion->id_estado_instalacion == '1') bg-blue-100 text-blue-800
                            @elseif($asignacion->id_estado_instalacion == '2') bg-yellow-100 text-yellow-800
                            @elseif($asignacion->id_estado_instalacion == '3') bg-green-100 text-green-800
                            @elseif($asignacion->id_estado_instalacion == '4') bg-red-100 text-red-800
                            @else bg-black-100 text-black-800
                            @endif">
                            @if($asignacion->id_estado_instalacion == '1') Iniciado
                            @elseif($asignacion->id_estado_instalacion == '2') En Proceso
                            @elseif($asignacion->id_estado_instalacion == '3') Finalizado
                            @elseif($asignacion->id_estado_instalacion == '4') Cancelado
                            @else Sin asignar
                            @endif
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                        @if ($asignacion->id_persona === null)
                            ---
                        @else
                            <a href="">
                                Ver detalles
                            </a>
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

<!-- Dropdown Template (Hidden) -->
<div id="filter-dropdown-template" class="filter-dropdown text-sm text-gray-700 font-sans">
    <!-- Search Box -->
    <div class="px-2 pb-2">
        <input type="text" class="filter-search w-full px-2 py-1.5 border border-gray-300 rounded text-sm focus:outline-none focus:border-blue-500 focus:ring-1 focus:ring-blue-500" placeholder="Buscar...">
    </div>
    
    <!-- Select All Checkbox -->
    <div class="px-2 pb-1 border-b border-gray-100">
        <label class="flex items-center space-x-2 cursor-pointer hover:bg-gray-50 p-1 rounded">
            <input type="checkbox" class="form-checkbox h-4 w-4 text-blue-600 rounded border-gray-300 select-all-checkbox focus:ring-blue-500">
            <span class="text-gray-700 font-medium text-xs">(Seleccionar Todo)</span>
        </label>
    </div>

    <!-- Options List (Scrollable Area) -->
    <div class="filter-options-container px-2 py-1 space-y-0.5 overflow-y-auto custom-scrollbar flex-grow">
        <!-- Options will be injected here -->
    </div>
    
    <!-- Footer with Actions (Sticky at bottom) -->
    <div class="p-2 border-t border-gray-200 bg-gray-50 mt-auto">
         <div class="flex justify-between items-center mb-2">
             <button class="text-xs text-blue-600 hover:text-blue-800 font-semibold btn-clear-column disabled:opacity-50 disabled:cursor-not-allowed">Limpiar Filtro</button>
         </div>
         <div class="flex justify-end space-x-2">
             <button class="px-3 py-1.5 bg-white border border-gray-300 rounded text-xs font-medium text-gray-700 hover:bg-gray-50 btn-cancel">Cancelar</button>
             <button class="px-3 py-1.5 bg-blue-600 border border-transparent rounded text-xs font-medium text-white hover:bg-blue-700 btn-ok">Aceptar</button>
         </div>
    </div>
</div>
@endsection

@section('scriptsJS')
<script>
$(document).ready(function() {
    var activeDropdown = null;
    var table = $('#excel-table');
    var tbody = table.find('tbody');
    var rows = tbody.find('tr').toArray(); // Cache all rows

    // State to store active filters: { colIndex: [selectedValues] }
    var activeFilters = {};

    // Helper: Apply Filters
    function applyFilters() {
        rows.forEach(function(row) {
            var $row = $(row);
            var show = true;
            for (var colIdx in activeFilters) {
                var filterValues = activeFilters[colIdx];
                var cellText = $row.find('td').eq(colIdx).text().trim();
                if (!filterValues.includes(cellText)) {
                    show = false;
                    break;
                }
            }
            $row.toggle(show);
        });
    }

    // Helper: Sort Function
    function sortColumn(th, colIndex, sortDirection) {
        // Reset other headers
        $('th').data('sort', '').find('.sort-indicator').remove();
        
        // Update current header
        th.data('sort', sortDirection);
        var arrow = sortDirection === 'asc' ? ' ↑' : ' ↓';
        th.find('.sort-indicator').remove();
        th.find('span').first().append('<span class="sort-indicator">' + arrow + '</span>');

        var rowsToSort = tbody.find('tr').toArray();
        rowsToSort.sort(function(a, b) {
            var valA = $(a).find('td').eq(colIndex).text().trim();
            var valB = $(b).find('td').eq(colIndex).text().trim();
            var numA = parseFloat(valA.replace(/[^0-9.-]+/g,""));
            var numB = parseFloat(valB.replace(/[^0-9.-]+/g,""));
            var isNum = !isNaN(numA) && !isNaN(numB) && valA.match(/^[0-9$.,]+$/) && valB.match(/^[0-9$.,]+$/);

            if (isNum) {
                return sortDirection === 'asc' ? numA - numB : numB - numA;
            } else {
                return sortDirection === 'asc' ? valA.localeCompare(valB) : valB.localeCompare(valA);
            }
        });

        $.each(rowsToSort, function(index, row) {
            tbody.append(row);
        });
    }

    // 1. Handle Filter Icon Click - CREATE DROPDOWN
    $('.filter-icon').on('click', function(e) {
        e.stopPropagation();
        var icon = $(this);
        var colIndex = icon.data('col');
        var th = icon.closest('th');

        // Nuclear cleanup: Remove ANY active dropdowns first
        $('.filter-dropdown.active').remove();
        activeDropdown = null;

        // Get unique values for this column from ALL rows
        var uniqueValues = new Set();
        rows.forEach(function(row) {
            var cellText = $(row).find('td').eq(colIndex).text().trim();
            uniqueValues.add(cellText);
        });
        
        // Sort values
        var sortedValues = Array.from(uniqueValues).sort(function(a, b) {
             var numA = parseFloat(a.replace(/[^0-9.-]+/g,""));
             var numB = parseFloat(b.replace(/[^0-9.-]+/g,""));
             var isNum = !isNaN(numA) && !isNaN(numB) && a.match(/^[0-9$.,]+$/) && b.match(/^[0-9$.,]+$/);
             if(isNum) return numA - numB;
             return a.localeCompare(b);
        });

        // Create Dropdown
        var dropdown = $('#filter-dropdown-template').clone().removeAttr('id');
        // Store metadata on the dropdown element
        dropdown.data('col', colIndex);
        dropdown.data('total-options', sortedValues.length);
        
        var container = dropdown.find('.filter-options-container');

        // Populate Options
        var allChecked = true;
        sortedValues.forEach(function(val) {
            var isChecked = true;
            if (activeFilters[colIndex]) {
                isChecked = activeFilters[colIndex].includes(val);
            }
            if (!isChecked) allChecked = false;

            var optionHtml = `
                <label class="filter-option flex items-center space-x-2 cursor-pointer hover:bg-gray-100 p-1 rounded">
                    <input type="checkbox" class="form-checkbox h-4 w-4 text-blue-600 rounded border-gray-300 filter-checkbox focus:ring-blue-500" value="${val}" ${isChecked ? 'checked' : ''}>
                    <span class="text-gray-700 select-none truncate">${val}</span>
                </label>
            `;
            container.append(optionHtml);
        });

        // Set initial state of Select All
        if (!activeFilters[colIndex]) {
            dropdown.find('.select-all-checkbox').prop('checked', true);
            dropdown.find('.btn-clear-column').prop('disabled', true);
        } else {
            dropdown.find('.select-all-checkbox').prop('checked', allChecked);
            dropdown.find('.btn-clear-column').prop('disabled', false);
        }

        // Position and Show Dropdown
        $('body').append(dropdown);
        
        // Ensure it's rendered to get dimensions
        dropdown.css({ display: 'flex', visibility: 'hidden' }); // Flex for sticky footer
        
        var iconEl = icon[0];
        var rect = iconEl.getBoundingClientRect();
        var dropdownWidth = dropdown.outerWidth();
        
        // Calculate positions relative to document
        var scrollTop = window.pageYOffset || document.documentElement.scrollTop;
        var scrollLeft = window.pageXOffset || document.documentElement.scrollLeft;
        
        var top = rect.bottom + scrollTop + 5;
        // Align Right edge of dropdown with Right edge of icon
        var left = rect.left + scrollLeft + rect.width - dropdownWidth; 
        
        // Edge detection
        if (left < 10) {
            left = 10;
        }
        
        dropdown.css({
            top: top,
            left: left,
            visibility: 'visible'
        });
        
        dropdown.addClass('active');
        activeDropdown = dropdown;
        
        // Focus search
        dropdown.find('.filter-search').focus();
    });

    // --- DELEGATED EVENT HANDLERS ---

    // Helper to update UI state (Select All checkbox)
    function updateUiState(dropdown) {
        var visibleOptions = dropdown.find('.filter-option:visible .filter-checkbox');
        var visibleChecked = dropdown.find('.filter-option:visible .filter-checkbox:checked');
        var isAllVisibleSelected = visibleOptions.length > 0 && visibleOptions.length === visibleChecked.length;
        dropdown.find('.select-all-checkbox').prop('checked', isAllVisibleSelected);
    }

    // 2. Handle Checkbox Change (UI Update only)
    $(document).on('change', '.filter-dropdown .filter-checkbox', function() {
        var dropdown = $(this).closest('.filter-dropdown');
        updateUiState(dropdown);
    });

    // 3. Handle "Select All"
    $(document).on('change', '.filter-dropdown .select-all-checkbox', function() {
        var dropdown = $(this).closest('.filter-dropdown');
        var isChecked = $(this).is(':checked');
        dropdown.find('.filter-option:visible .filter-checkbox').prop('checked', isChecked);
        updateUiState(dropdown);
    });

    // 4. Handle Search
    $(document).on('input', '.filter-dropdown .filter-search', function() {
        var dropdown = $(this).closest('.filter-dropdown');
        var term = $(this).val().toLowerCase();
        dropdown.find('.filter-option').each(function() {
            var text = $(this).text().toLowerCase();
            if (text.indexOf(term) > -1) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
        updateUiState(dropdown);
    });

    // 5. Handle "Clear Filter From Column"
    $(document).on('click', '.filter-dropdown .btn-clear-column', function(e) {
        e.preventDefault();
        var dropdown = $(this).closest('.filter-dropdown');
        dropdown.find('.filter-checkbox').prop('checked', true);
        // Trigger OK logic
        dropdown.find('.btn-ok').click();
    });

    // 6. Handle OK Button (Aceptar)
    $(document).on('click', '.filter-dropdown .btn-ok', function(e) {
        e.preventDefault();
        var dropdown = $(this).closest('.filter-dropdown');
        var colIndex = dropdown.data('col');
        var totalOptions = dropdown.data('total-options');
        var th = $('th').find('.filter-icon[data-col="' + colIndex + '"]').closest('th');

        try {
            var selectedValues = [];
            var checkedOptions = dropdown.find('.filter-checkbox:checked');
            
            checkedOptions.each(function() {
                selectedValues.push($(this).val());
            });

            // If all options are selected, remove filter
            if (selectedValues.length === totalOptions) {
                delete activeFilters[colIndex];
                th.removeClass('filtered');
            } else {
                activeFilters[colIndex] = selectedValues;
                th.addClass('filtered');
            }

            applyFilters();
        } catch (err) {
            console.error("Filter failed", err);
        } finally {
            dropdown.remove();
            activeDropdown = null;
        }
    });

    // 7. Handle Cancel Button (Cancelar)
    $(document).on('click', '.filter-dropdown .btn-cancel', function(e) {
        e.preventDefault();
        $(this).closest('.filter-dropdown').remove();
        activeDropdown = null;
    });

    // 8. Prevent closing when clicking inside dropdown
    $(document).on('click', '.filter-dropdown', function(e) {
        e.stopPropagation();
    });

    // 9. Close dropdown when clicking outside
    $(document).on('click', function(e) {
        // If click is not on a filter icon
        if (!$(e.target).closest('.filter-icon').length) {
            $('.filter-dropdown.active').remove();
            activeDropdown = null;
        }
    });

    // 10. Header Click Sort
    $('th').on('click', function(e) {
        // If click is on the filter icon, do nothing (handled by icon click)
        if ($(e.target).hasClass('filter-icon') || $(e.target).closest('.filter-icon').length) return;
        
        var th = $(this);
        // Find the column index associated with this header
        var colIndex = th.find('.filter-icon').data('col');
        
        var currentSort = th.data('sort');
        var newSort = currentSort === 'asc' ? 'desc' : 'asc';
        
        sortColumn(th, colIndex, newSort);
    });
});
</script>
@endsection
