@extends('master')

@section('headerContent')
<h5 class="!mb-0">
    Editar Instalación
</h5>
<ol class="breadcrumb mt-[12px] md:mt-0">
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        <a href="/main" class="inline-block relative ltr:pl-[22px] rtl:pr-[22px] transition-all hover:text-primary-500">
            <i class="material-symbols-outlined absolute ltr:left-0 rtl:right-0 !text-lg -mt-px text-primary-500 top-1/2 -translate-y-1/2">home</i>
            Dashboard
        </a>
    </li>
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        <a href="{{ url('/dashboard/hpinstalacion') }}" class="inline-block relative transition-all hover:text-primary-500">
            Instalaciones
        </a>
    </li>
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        Editar
    </li>
</ol>
@endsection

@section('titleContent')
<h3 class="!mb-0">
    Edición de Instalación
</h3>
@endsection

@section('bodyContent')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="trezo-card p-6">
        <form id="hpinstalacion-form">
            @csrf
            <input type="hidden" id="instalacion_id" value="{{ $id }}">

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-6">
                
                <div>
                    <label for="id_casa" class="block text-sm font-medium text-gray-700 mb-1">Casa *</label>
                    <select id="id_casa" name="id_casa" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                        <option value="">Cargando casas...</option>
                    </select>
                    <p id="error-id_casa" class="text-red-500 text-xs mt-1 hidden"></p>
                </div>

                <div>
                    <label for="id_persona" class="block text-sm font-medium text-gray-700 mb-1">Persona</label>
                    <select id="id_persona" name="id_persona" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="">Cargando personas...</option>
                    </select>
                    <p id="error-id_persona" class="text-red-500 text-xs mt-1 hidden"></p>
                </div>

                <div>
                    <label for="tipo_objeto" class="block text-sm font-medium text-gray-700 mb-1">Tipo Objeto</label>
                    <input type="text" id="tipo_objeto" name="tipo_objeto" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <p id="error-tipo_objeto" class="text-red-500 text-xs mt-1 hidden"></p>
                </div>

                <div>
                    <label for="numero_unidades_residenciales" class="block text-sm font-medium text-gray-700 mb-1">Num. Unidades Residenciales</label>
                    <input type="number" id="numero_unidades_residenciales" name="numero_unidades_residenciales" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <p id="error-numero_unidades_residenciales" class="text-red-500 text-xs mt-1 hidden"></p>
                </div>

                <div>
                    <label for="A_" class="block text-sm font-medium text-gray-700 mb-1">A_</label>
                    <input type="number" step="any" id="A_" name="A_" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <p id="error-A_" class="text-red-500 text-xs mt-1 hidden"></p>
                </div>

                <div>
                    <label for="B_" class="block text-sm font-medium text-gray-700 mb-1">B_</label>
                    <input type="number" step="any" id="B_" name="B_" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <p id="error-B_" class="text-red-500 text-xs mt-1 hidden"></p>
                </div>

                <div>
                    <label for="Do_" class="block text-sm font-medium text-gray-700 mb-1">Do_</label>
                    <input type="number" step="any" id="Do_" name="Do_" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <p id="error-Do_" class="text-red-500 text-xs mt-1 hidden"></p>
                </div>

                <div>
                    <label for="D_" class="block text-sm font-medium text-gray-700 mb-1">D_</label>
                    <input type="number" step="any" id="D_" name="D_" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <p id="error-D_" class="text-red-500 text-xs mt-1 hidden"></p>
                </div>

                <div>
                    <label for="latitude" class="block text-sm font-medium text-gray-700 mb-1">Latitud</label>
                    <input type="text" id="latitude" name="latitude" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <p id="error-latitude" class="text-red-500 text-xs mt-1 hidden"></p>
                </div>

                <div>
                    <label for="longitude" class="block text-sm font-medium text-gray-700 mb-1">Longitud</label>
                    <input type="text" id="longitude" name="longitude" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <p id="error-longitude" class="text-red-500 text-xs mt-1 hidden"></p>
                </div>

                <div>
                    <label for="exactitud" class="block text-sm font-medium text-gray-700 mb-1">Exactitud</label>
                    <input type="text" id="exactitud" name="exactitud" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <p id="error-exactitud" class="text-red-500 text-xs mt-1 hidden"></p>
                </div>

                <div>
                    <label for="deteccion_manual" class="block text-sm font-medium text-gray-700 mb-1">Detección Manual</label>
                    <select id="deteccion_manual" name="deteccion_manual" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="0">No</option>
                        <option value="1">Sí</option>
                    </select>
                    <p id="error-deteccion_manual" class="text-red-500 text-xs mt-1 hidden"></p>
                </div>

                <div>
                    <label for="asociacion" class="block text-sm font-medium text-gray-700 mb-1">Asociación</label>
                    <input type="text" id="asociacion" name="asociacion" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <p id="error-asociacion" class="text-red-500 text-xs mt-1 hidden"></p>
                </div>

                <div>
                    <label for="microducto" class="block text-sm font-medium text-gray-700 mb-1">Microproducto</label>
                    <input type="text" id="microducto" name="microducto" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <p id="error-microducto" class="text-red-500 text-xs mt-1 hidden"></p>
                </div>

                <div>
                    <label for="estado_instalacion" class="block text-sm font-medium text-gray-700 mb-1">Estado Instalación</label>
                    <input type="text" id="estado_instalacion" name="estado_instalacion" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <p id="error-estado_instalacion" class="text-red-500 text-xs mt-1 hidden"></p>
                </div>

            </div>

            <div class="flex justify-end gap-4">
                <a href="{{ url('/dashboard/hpinstalacion') }}" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-md hover:bg-gray-300 transition-colors">Cancelar</a>
                <button type="submit" id="btn-guardar" class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 transition-colors flex items-center">
                    <span class="material-symbols-outlined mr-2 text-sm">save</span> Actualizar Instalación
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

@section('scriptsJS')
<script src="{{ asset('js/CRUD.js') }}"></script>
<script>
$(document).ready(function() {
    const instalacionId = $('#instalacion_id').val();
    const form = $('#hpinstalacion-form');

    // Cargar listas y datos
    Promise.all([
        // Cargar Casas
        $.ajax({
            url: "{{ url('/rcasa') }}",
            type: 'GET',
            dataType: 'json'
        }),
        // Cargar Personas
        $.ajax({
            url: "{{ url('/rpersona') }}",
            type: 'GET',
            data: { length: -1 },
            dataType: 'json'
        }),
        // Cargar Datos de la Instalación
        $.ajax({
            url: "{{ url('/rhpinstalacion/getById') }}/" + instalacionId,
            type: 'GET',
            dataType: 'json'
        })
    ]).then(function(responses) {
        const casasResponse = responses[0];
        const personasResponse = responses[1];
        const instalacionResponse = responses[2];

        // Poblar Casas
        let casasOptions = '<option value="">Seleccione una casa</option>';
        if (casasResponse.success && casasResponse.data) {
            casasResponse.data.forEach(casa => {
                casasOptions += `<option value="${casa.id}">${casa.numero} (ID: ${casa.id})</option>`;
            });
        }
        $('#id_casa').html(casasOptions);

        // Poblar Personas
        let personasOptions = '<option value="">Seleccione una persona</option>';
        // DataTables response structure might be different. Usually 'data' property contains the array.
        // If it's pure DataTables, it might be inside 'data' or directly the array if not paginated?
        // RPersonaController uses DataTables::of($personas)->make(true);
        // This returns { draw: x, recordsTotal: y, recordsFiltered: z, data: [...] }
        let personasList = [];
        if (personasResponse.data) {
            personasList = personasResponse.data;
        } else if (Array.isArray(personasResponse)) {
            personasList = personasResponse;
        }
        
        personasList.forEach(persona => {
            let nombre = persona.nombre_completo || `${persona.nombre} ${persona.paterno}`; 
            personasOptions += `<option value="${persona.id}">${nombre}</option>`;
        });
        $('#id_persona').html(personasOptions);

        // Poblar Formulario
        if (instalacionResponse.success && instalacionResponse.data) {
            const data = instalacionResponse.data;
            $('#id_casa').val(data.id_casa);
            $('#id_persona').val(data.id_persona);
            $('#tipo_objeto').val(data.tipo_objeto);
            $('#numero_unidades_residenciales').val(data.numero_unidades_residenciales);
            $('#A_').val(data.A_);
            $('#B_').val(data.B_);
            $('#Do_').val(data.Do_);
            $('#D_').val(data.D_);
            $('#latitude').val(data.latitude);
            $('#longitude').val(data.longitude);
            $('#exactitud').val(data.exactitud);
            $('#deteccion_manual').val(data.deteccion_manual ? 1 : 0);
            $('#asociacion').val(data.asociacion);
            $('#microducto').val(data.microducto);
            $('#estado_instalacion').val(data.estado_instalacion);
        } else {
            Swal.fire('Error', 'No se pudieron cargar los datos de la instalación.', 'error');
        }

    }).catch(function(err) {
        console.error(err);
        Swal.fire('Error', 'Ocurrió un error al cargar los datos.', 'error');
    });

    // Manejar envío del formulario
    form.on('submit', function(e) {
        e.preventDefault();
        
        $('.text-red-500').addClass('hidden').text('');
        $('input, select').removeClass('border-red-500');
        
        const btn = $('#btn-guardar');
        const originalText = btn.html();
        btn.prop('disabled', true).html('<span class="material-symbols-outlined mr-2 animate-spin">refresh</span> Procesando...');

        const formData = form.serialize();

        // Usar CRUD.update o $.ajax directo
        $.ajax({
            url: "{{ url('/rhpinstalacion') }}/" + instalacionId,
            type: 'PUT',
            data: formData,
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: '¡Éxito!',
                        text: 'Instalación actualizada correctamente.',
                        showConfirmButton: false,
                        timer: 2000
                    }).then(() => {
                        window.location.href = "{{ url('/dashboard/hpinstalacion') }}";
                    });
                } else {
                    Swal.fire('Error', response.message || 'Error al actualizar.', 'error');
                    btn.prop('disabled', false).html(originalText);
                }
            },
            error: function(xhr) {
                btn.prop('disabled', false).html(originalText);
                
                if (xhr.status === 422) {
                    let errors = xhr.responseJSON.errors;
                    for (const key in errors) {
                        $(`#${key}`).addClass('border-red-500');
                        $(`#error-${key}`).text(errors[key][0]).removeClass('hidden');
                    }
                    Swal.fire({
                        icon: 'error',
                        title: 'Error de Validación',
                        text: 'Por favor revisa los campos marcados.'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: xhr.responseJSON?.message || 'Ocurrió un error inesperado.'
                    });
                }
            }
        });
    });
});
</script>
@endsection
