@extends('master')

@section('stylesCSS')
    <link rel="stylesheet" href="https://cdn.datatables.net/2.3.5/css/dataTables.tailwindcss.css">
@endsection

@section('headerContent')
<h5 class="!mb-0">
    Gestión de Instalaciones
</h5>
<ol class="breadcrumb mt-[12px] md:mt-0">
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        <a href="/main" class="inline-block relative ltr:pl-[22px] rtl:pr-[22px] transition-all hover:text-primary-500">
            <i class="material-symbols-outlined absolute ltr:left-0 rtl:right-0 !text-lg -mt-px text-primary-500 top-1/2 -translate-y-1/2">home</i>
            Dashboard
        </a>
    </li>
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        Instalaciones
    </li>
</ol>
@endsection

@section('titleContent')
<h3 class="!mb-0">
    Listado de Instalaciones
</h3>
@endsection

@section('bodyContent')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="trezo-card p-5">

        <!-- Tabla de Instalaciones -->
        <table id="tabla-instalaciones" class="display stripe border border-gray-200 rounded-lg" style="width:100%">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Fecha</th>
                    <th>Equipo</th>
                    <th>Direccion</th>
                    <th>Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <!-- Los datos se cargarán vía AJAX -->
            </tbody>
        </table>
    </div>

</div>
@endsection

@section('scriptsJS')
<script src="https://cdn.datatables.net/2.3.5/js/dataTables.js"></script>
<script src="https://cdn.datatables.net/2.3.5/js/dataTables.tailwindcss.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>

<script>
$(document).ready(function() {
    // Inicializar DataTable (Server-side)
    const table = new DataTable('#tabla-instalaciones', {
        processing: true,
        serverSide: true,
        ajax: {
            url: "{{ route('rhpinstalacion.getData') }}",
            type: "GET",
            error: function(xhr) {
                console.error('Error cargando datos:', xhr);
            }
        },
        columns: [
            { data: 'id', name: 'id', className: 'text-center font-mono text-xs text-gray-500' },
            { data: 'fecha_asignacion', name: 'fecha_asignacion', defaultContent: '-' },
            { data: 'nombre_completo', name: 'nombre_completo', className: 'font-medium text-gray-800' },
            { data: 'direccion', name: 'direccion', className: 'text-gray-600 text-sm' },
            { data: 'estado_instalacion', name: 'estado_instalacion', className: 'text-center' },
            { 
                data: 'action', 
                name: 'action', 
                orderable: false, 
                searchable: false,
                className: 'text-center'
            }
        ],
        order: [[0, 'desc']],
        info: false,
        lengthMenu: [10, 25, 50],

        dom: '<"flex flex-col sm:flex-row justify-between items-center gap-4 mb-4"lf>rt<"flex flex-col sm:flex-row justify-between items-center gap-4 mt-4"ip>',
        rowCallback: function(row, data, index) {
            $(row).addClass('hover:bg-gray-50 transition-colors');
        }
    });

    
});
</script>
@endsection
