@extends('master')

@section('stylesCSS')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endsection

@section('headerContent')
<div class="flex flex-col md:flex-row md:items-center justify-between gap-4 mb-6">
    <div>
        <h5 class="text-2xl font-bold text-gray-800 tracking-tight">
            Instalación #{{ $id }}
        </h5>
        <ol class="flex items-center gap-2 mt-2 text-sm text-gray-500">
            <li>
                <a href="/main" class="hover:text-blue-600 transition-colors flex items-center gap-1">
                    <span class="material-symbols-outlined text-lg">home</span>
                </a>
            </li>
            <li class="flex items-center">
                <span class="material-symbols-outlined text-gray-400 text-lg">chevron_right</span>
            </li>
            <li>
                <a href="{{ url('/dashboard/hpinstalacion') }}" class="hover:text-blue-600 transition-colors">
                    Instalaciones
                </a>
            </li>
            <li class="flex items-center">
                <span class="material-symbols-outlined text-gray-400 text-lg">chevron_right</span>
            </li>
            <li class="font-medium text-blue-600">
                Editar
            </li>
        </ol>
    </div>
</div>
@endsection

@section('titleContent')
@endsection

@section('bodyContent')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8 max-w-7xl">
    
    <form id="hpinstalacion-form" class="space-y-8">
        @csrf
        <input type="hidden" id="instalacion_id" value="{{ $id }}">

        <!-- Info Cards Section -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <!-- Equipo Card -->
            <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 hover:shadow-md transition-shadow">
                <div class="flex items-start gap-4">
                    <div class="p-3 bg-blue-50 text-blue-600 rounded-xl">
                        <span class="material-symbols-outlined">group</span>
                    </div>
                    <div>
                        <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider mb-1">{{ __('equipo') }}</p>
                        <h4 class="font-medium text-gray-800 text-lg">{{ $persona->nombre }} {{ $persona->paterno }}</h4>
                        <p class="text-sm text-gray-500">{{ $persona->materno }}</p>
                    </div>
                </div>
                <input type="hidden" name="id_persona" value="{{ $hpinstalacion->id_persona }}">
            </div>

            <!-- Casa Card -->
            <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 hover:shadow-md transition-shadow">
                <div class="flex items-start gap-4">
                    <div class="p-3 bg-orange-50 text-orange-600 rounded-xl">
                        <span class="material-symbols-outlined">home</span>
                    </div>
                    <div>
                        <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider mb-1">{{ __('casa') }}</p>
                        <h4 class="font-medium text-gray-800 text-lg">{{ $casa->nombre_calle }} {{ $casa->numero }}</h4>
                        <p class="text-sm text-gray-500">{{ $casa->nombre_ubicacion }} {{ $casa->nombre_codigo_postal }}</p>
                    </div>
                </div>
                <input type="hidden" name="id_casa" value="{{ $hpinstalacion->id_casa }}">
            </div>

            <!-- Supervisor Card -->
            <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100 hover:shadow-md transition-shadow">
                <div class="flex items-start gap-4">
                    <div class="p-3 bg-purple-50 text-purple-600 rounded-xl">
                        <span class="material-symbols-outlined">person_check</span>
                    </div>
                    <div>
                        <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider mb-1">{{ __('supervisor') }}</p>
                        <h4 class="font-medium text-gray-800 text-lg">{{ $supervisor->nombre }} {{ $supervisor->paterno }}</h4>
                        <p class="text-sm text-gray-500">{{ $supervisor->materno }}</p>
                    </div>
                </div>
                <input type="hidden" name="id_persona_supervisor" value="{{ $hpinstalacion->id_persona_supervisor }}">
            </div>
        </div>

        <div class="bg-white border border-gray-200 rounded-2xl shadow-sm p-8">

                <!-- Tipo de Objeto y Unidades -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8">
                    <div>
                        <label for="id_tipo_objeto" class="block text-sm font-semibold text-gray-700 mb-2">{{ __('tipo_objeto') }}</label>
                        <div class="relative">
                            <select id="id_tipo_objeto" name="id_tipo_objeto" class="appearance-none w-full rounded-xl border-gray-200 bg-gray-50 text-gray-700 py-3 px-4 pr-8 shadow-sm focus:border-blue-500 focus:bg-white focus:ring-4 focus:ring-blue-500/10 transition-all cursor-pointer">
                                @foreach($tipo_objeto as $data)
                                    <option value="{{ $data->id }}" {{ $hpinstalacion->id_tipo_objeto == $data->id ? 'selected' : '' }}>
                                        {{ $data->nombre }}
                                    </option>
                                @endforeach
                            </select>
                            <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-4 text-gray-500">
                                <span class="material-symbols-outlined text-lg">expand_more</span>
                            </div>
                        </div>
                        <p id="error-id_tipo_objeto" class="text-red-500 text-xs mt-1 hidden"></p>
                    </div>
                    <div>
                        <label for="numero_unidades_residenciales" class="block text-sm font-semibold text-gray-700 mb-2">{{ __('unidades_residenciales') }}</label>
                        <input type="number" id="numero_unidades_residenciales" name="numero_unidades_residenciales" value="{{ $hpinstalacion->numero_unidades_residenciales }}" 
                               class="w-full rounded-xl border-gray-200 bg-gray-50 text-gray-700 py-3 px-4 shadow-sm focus:border-blue-500 focus:bg-white focus:ring-4 focus:ring-blue-500/10 transition-all placeholder:text-gray-400">
                        <p id="error-numero_unidades_residenciales" class="text-red-500 text-xs mt-1 hidden"></p>
                    </div>
                </div>

                <!-- Vivienda Options (Checkbox Cards) -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-10">
                    <label class="relative flex items-center p-4 rounded-xl border border-gray-200 cursor-pointer hover:border-blue-300 hover:bg-blue-50/50 transition-all group">
                        <input type="hidden" name="vivienda_unifamiliar" value="0">
                        <input type="checkbox" id="vivienda_unifamiliar" name="vivienda_unifamiliar" value="1" {{ $hpinstalacion->vivienda_unifamiliar ? 'checked' : '' }} 
                               class="w-5 h-5 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <div class="ml-4">
                            <span class="block text-sm font-semibold text-gray-800">{{ __('vivienda_unifamiliar') }}</span>
                            <span class="block text-xs text-gray-500 group-hover:text-blue-600/70 transition-colors">{{ __('vivienda_unifamiliar_desc') }}</span>
                        </div>
                    </label>

                    <label class="relative flex items-center p-4 rounded-xl border border-gray-200 cursor-pointer hover:border-blue-300 hover:bg-blue-50/50 transition-all group">
                        <input type="hidden" name="vivienda_multifamiliar" value="0">
                        <input type="checkbox" id="vivienda_multifamiliar" name="vivienda_multifamiliar" value="1" {{ $hpinstalacion->vivienda_multifamiliar ? 'checked' : '' }} 
                               class="w-5 h-5 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <div class="ml-4">
                            <span class="block text-sm font-semibold text-gray-800">{{ __('vivienda_multifamiliar') }}</span>
                            <span class="block text-xs text-gray-500 group-hover:text-blue-600/70 transition-colors">{{ __('vivienda_multifamiliar_desc') }}</span>
                        </div>
                    </label>
                </div>

                <div class="border-t border-gray-100 my-8"></div>

                <!-- Marcador de bola de posicion -->
                <div class="mb-10">
                    <div class="flex items-center gap-2 mb-6">
                        <div class="p-2 bg-indigo-50 text-indigo-600 rounded-lg">
                            <span class="material-symbols-outlined">location_on</span>
                        </div>
                        <h4 class="text-lg font-bold text-gray-800">{{ __('marcador_posicion') }}</h4>
                    </div>

                    <div class="flex flex-col lg:flex-row gap-8 items-start">
                        <!-- Imagen Reference -->
                        <div class="w-full lg:w-1/3 bg-gray-50 rounded-2xl border border-gray-200 p-6 flex flex-col items-center justify-center text-center">
                            <img src="{{ asset('assets/images/instalacion.png') }}"
                                 alt="Referencia"
                                 class="max-h-48 object-contain mb-4 filter drop-shadow-md">
                            <p class="text-xs text-gray-500 font-medium">{{ __('guia_referencia') }}</p>
                        </div>
                        
                        <!-- Inputs -->
                        <div class="w-full lg:w-2/3">
                            <div class="grid grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2">{{ __('medida_A') }}</label>
                                    <input type="number" step="any" id="A_" name="A_" value="{{ $hpinstalacion->A_ }}" 
                                           class="w-full rounded-xl border-gray-200 bg-gray-50 py-3 px-4 focus:bg-white focus:border-indigo-500 focus:ring-4 focus:ring-indigo-500/10 transition-all">
                                </div>
                                <div>
                                    <label class="block text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2">{{ __('medida_B') }}</label>
                                    <input type="number" step="any" id="B_" name="B_" value="{{ $hpinstalacion->B_ }}" 
                                           class="w-full rounded-xl border-gray-200 bg-gray-50 py-3 px-4 focus:bg-white focus:border-indigo-500 focus:ring-4 focus:ring-indigo-500/10 transition-all">
                                </div>
                                <div>
                                    <label class="block text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2">{{ __('medida_Do') }}</label>
                                    <input type="number" step="any" id="Do_" name="Do_" value="{{ $hpinstalacion->Do_ }}" 
                                           class="w-full rounded-xl border-gray-200 bg-gray-50 py-3 px-4 focus:bg-white focus:border-indigo-500 focus:ring-4 focus:ring-indigo-500/10 transition-all">
                                </div>
                                <div>
                                    <label class="block text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2">{{ __('medida_D') }}</label>
                                    <input type="number" step="any" id="D_" name="D_" value="{{ $hpinstalacion->D_ }}" 
                                           class="w-full rounded-xl border-gray-200 bg-gray-50 py-3 px-4 focus:bg-white focus:border-indigo-500 focus:ring-4 focus:ring-indigo-500/10 transition-all">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- GPS & Exactitud -->
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-10">
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">{{ __('latitud') }}</label>
                        <div class="relative">
                             <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none text-gray-400">
                                <span class="material-symbols-outlined text-lg">north</span>
                            </div>
                            <input type="text" id="latitude" name="latitude" value="{{ $hpinstalacion->latitude }}" 
                                   class="pl-10 w-full rounded-xl border-gray-200 bg-gray-50 py-3 focus:bg-white focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all">
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">{{ __('longitud') }}</label>
                        <div class="relative">
                             <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none text-gray-400">
                                <span class="material-symbols-outlined text-lg">east</span>
                            </div>
                            <input type="text" id="longitude" name="longitude" value="{{ $hpinstalacion->longitude }}" 
                                   class="pl-10 w-full rounded-xl border-gray-200 bg-gray-50 py-3 focus:bg-white focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all">
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">{{ __('exactitud') }}</label>
                        <div class="relative">
                             <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none text-gray-400">
                                <span class="material-symbols-outlined text-lg">gps_fixed</span>
                            </div>
                            <input type="text" id="exactitud" name="exactitud" value="{{ $hpinstalacion->exactitud }}" 
                                   class="pl-10 w-full rounded-xl border-gray-200 bg-gray-50 py-3 focus:bg-white focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all">
                        </div>
                    </div>
                </div>
                
                <div class="mb-10">
                     <label class="inline-flex items-center p-3 rounded-lg border border-transparent hover:bg-gray-50 transition-colors cursor-pointer">
                         <input type="hidden" name="deteccion_manual" value="0">
                         <input type="checkbox" id="deteccion_manual" name="deteccion_manual" value="1" {{ $hpinstalacion->deteccion_manual ? 'checked' : '' }} 
                                class="w-5 h-5 text-blue-600 rounded border-gray-300 focus:ring-blue-500">
                         <span class="ml-3 text-sm font-medium text-gray-700">{{ __('deteccion_manual') }}</span>
                     </label>
                </div>

                <div class="border-t border-gray-100 my-8"></div>

                <!-- Codificación de colores -->
                <div class="mb-8">
                    <div class="flex items-center gap-2 mb-6">
                        <div class="p-2 bg-pink-50 text-pink-600 rounded-lg">
                            <span class="material-symbols-outlined">palette</span>
                        </div>
                        <h4 class="text-lg font-bold text-gray-800">{{ __('codificacion_colores') }}</h4>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                        <div>
                            <label for="id_color_asociacion" class="block text-sm font-semibold text-gray-700 mb-2">{{ __('color_asociacion') }}</label>
                            <select id="id_color_asociacion" name="id_color_asociacion" class="select2-color w-full">
                                <option value=""></option>
                                @foreach($colors as $color)
                                    <option value="{{ $color->id }}" data-color="{{ $color->codigo_hexadecimal }}" {{ $hpinstalacion->id_color_asociacion == $color->id ? 'selected' : '' }}>
                                        {{ $color->nombre }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <label for="id_color_microducto" class="block text-sm font-semibold text-gray-700 mb-2">{{ __('color_microducto') }}</label>
                            <select id="id_color_microducto" name="id_color_microducto" class="select2-color w-full">
                                <option value=""></option>
                                @foreach($colors as $color)
                                    <option value="{{ $color->id }}" data-color="{{ $color->codigo_hexadecimal }}" {{ $hpinstalacion->id_color_microducto == $color->id ? 'selected' : '' }}>
                                        {{ $color->nombre }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                
                <!-- Estado -->
                <div class="mb-8">
                    <label for="id_estado_instalacion" class="block text-sm font-semibold text-gray-700 mb-2">{{ __('estado_instalacion') }}</label>
                    <div class="relative">
                        <select id="id_estado_instalacion" name="id_estado_instalacion" class="appearance-none w-full rounded-xl border-gray-200 bg-indigo-50 text-indigo-900 font-medium py-3 px-4 pr-8 shadow-sm focus:border-indigo-500 focus:bg-white focus:ring-4 focus:ring-indigo-500/10 transition-all cursor-pointer">
                            @foreach($estado_instalacion as $data)
                                <option value="{{ $data->id }}" {{ $hpinstalacion->id_estado_instalacion == $data->id ? 'selected' : '' }}>
                                    {{ $data->nombre }}
                                </option>
                            @endforeach
                        </select>
                        <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-4 text-indigo-500">
                            <span class="material-symbols-outlined text-lg">expand_more</span>
                        </div>
                    </div>
                </div>
            </div> <!-- End white card content -->

            <!-- Actions Bar -->
            <div class="flex flex-col md:flex-row justify-end items-center gap-4 mt-8 pt-6 border-t border-gray-200">
                <a href="{{ url($urlList) }}" class="w-full md:w-auto text-center px-6 py-3 text-sm font-medium text-gray-500 hover:text-gray-700 hover:bg-gray-100 rounded-xl transition-colors">
                    {{ __('accion_cancelar') }}
                </a>
                
                <a href="{{ url('/dashboard/informejob/'.$id) }}" target="_blank" rel="noopener noreferrer" 
                   class="w-full md:w-auto justify-center inline-flex items-center gap-2 px-6 py-3 bg-white text-gray-700 border border-gray-200 shadow-sm rounded-xl hover:bg-gray-50 hover:border-gray-300 transition-all group">
                    <span class="material-symbols-outlined text-red-500 group-hover:scale-110 transition-transform">picture_as_pdf</span> 
                    <span>{{ __('accion_informe_pdf') }}</span>
                </a>

                <button type="submit" id="btn-guardar" 
                        class="w-full md:w-auto justify-center inline-flex items-center gap-2 px-6 py-3 bg-blue-600 text-white shadow-lg shadow-blue-500/30 rounded-xl hover:bg-blue-700 hover:shadow-blue-500/40 transition-all transform hover:-translate-y-0.5">
                    <span class="material-symbols-outlined text-sm">save</span> 
                    <span>{{ __('accion_guardar') }}</span>
                </button>

                <button type="button" id="btn-finalizar"
                        class="w-full md:w-auto justify-center inline-flex items-center gap-2 px-6 py-3 bg-gray-900 text-white shadow-lg shadow-gray-900/20 rounded-xl hover:bg-black hover:shadow-gray-900/30 transition-all transform hover:-translate-y-0.5">
                    <span class="material-symbols-outlined text-sm text-yellow-400">check_circle</span>
                    <span>{{ __('accion_finalizar') }}</span>
                </button>
            </div>
        </form>
        <!-- Image Upload Section -->
        <div class="mt-8 pt-8 border-t border-gray-200">
            <!-- Upload Section -->
            <div class="bg-white border border-gray-200 rounded-2xl shadow-sm p-8 mb-10">
                <div class="flex items-center gap-4 mb-8">
                    <div class="w-12 h-12 rounded-full bg-blue-50 flex items-center justify-center">
                        <span class="material-symbols-outlined text-blue-600 text-2xl">add_photo_alternate</span>
                    </div>
                    <div>
                        <h4 class="text-xl font-bold text-gray-800">{{ __('galeria_trabajo') }}</h4>
                        <p class="text-sm text-gray-500">{{ __('galeria_descripcion') }}</p>
                    </div>
                </div>

                <form id="upload-form" enctype="multipart/form-data" class="relative">
                    @csrf
                    <input type="hidden" id="upload_instalacion_id" value="{{ $id }}">
                    
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                        <!-- Left: File Selector -->
                        <div class="space-y-4">
                            <label class="block text-sm font-semibold text-gray-700">{{ __('seleccionar_imagen') }}</label>
                            
                            <div class="relative group h-48 flex flex-col items-center justify-center bg-gray-50 rounded-xl border-2 border-dashed border-gray-300 hover:border-blue-400 hover:bg-blue-50 transition-all overflow-hidden">
                                    <input type="file" id="imagen" name="imagen" accept="image/*" 
                                           class="absolute inset-0 w-full h-full opacity-0 cursor-pointer z-20">
                                    
                                    <div id="drop-zone-content" class="text-center pointer-events-none p-4">
                                        <span class="material-symbols-outlined text-4xl text-gray-400 mb-2">cloud_upload</span>
                                        <p class="text-sm font-medium text-gray-600">{{ __('arrastra_imagen') }}</p>
                                        <p class="text-xs text-gray-400 mt-1">JPG, PNG, GIF {{ __('hasta') }} 5MB</p>
                                    </div>
                                    
                                    <!-- Image Preview -->
                                    <div id="image-preview" class="hidden relative z-10 p-2">
                                        <div class="relative">
                                            <img id="preview-img" src="#" alt="Vista previa" class="h-40 w-auto rounded-lg shadow-md object-contain border border-gray-200">
                                            <button type="button" id="remove-preview" class="absolute -top-3 -right-3 bg-white text-red-500 rounded-full p-1 shadow-md hover:bg-red-50 transition-colors border border-gray-200" title="Eliminar imagen">
                                                <span class="material-symbols-outlined text-sm font-bold">close</span>
                                            </button>
                                        </div>
                                    </div>
                            </div>
                            <div class="flex items-start gap-2 text-xs text-gray-400 px-1">
                                <span class="material-symbols-outlined text-sm shrink-0">info</span>
                                <p>{{ __('formatos_permitidos') }}: JPG, PNG, GIF. {{ __('max_tamano') }}: 5MB.</p>
                            </div>
                        </div>

                        <!-- Right: Description & Action -->
                        <div class="space-y-4">
                            <label for="descripcion" class="block text-sm font-semibold text-gray-700">{{ __('descripcion') }}</label>
                            <div class="relative">
                                <textarea id="descripcion" name="descripcion" rows="5" 
                                          class="w-full rounded-xl border-gray-300 bg-gray-50 focus:bg-white shadow-sm focus:border-blue-500 focus:ring-blue-500 transition-all resize-none text-sm py-3 px-4"
                                          placeholder="{{ __('agrega_notas') }}..."></textarea>
                            </div>

                            <button type="submit" id="btn-upload" 
                                    class="w-full group relative inline-flex items-center justify-center px-8 py-3 text-sm font-medium text-white bg-gray-900 rounded-xl hover:bg-black focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-900 transition-all shadow-lg hover:shadow-xl overflow-hidden">
                                <div class="absolute inset-0 w-full h-full bg-gradient-to-r from-transparent via-white/10 to-transparent -translate-x-full group-hover:translate-x-full transition-transform duration-700 ease-in-out"></div>
                                <span class="material-symbols-outlined mr-2">cloud_upload</span>
                                <span>{{ __('subir_imagen') }}</span>
                            </button>
                        </div>
                    </div>

                    <!-- Hidden Progress Section -->
                    <div id="upload-progress" class="hidden mt-6 bg-blue-50 rounded-xl p-4 border border-blue-100">
                        <div class="flex justify-between items-center mb-2">
                            <span class="text-xs font-semibold text-blue-700 uppercase tracking-wider">{{ __('subiendo') }}...</span>
                            <span id="upload-status" class="text-xs font-medium text-blue-600">{{ __('iniciando') }}...</span>
                        </div>
                        <div class="w-full bg-blue-200 rounded-full h-2">
                            <div id="progress-bar" class="bg-blue-600 h-2 rounded-full transition-all duration-300 shadow-[0_0_10px_rgba(37,99,235,0.5)]" style="width: 0%"></div>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Images List -->
            <div id="images-container">
                <div id="images-loading" class="text-center py-8">
                    <span class="material-symbols-outlined text-4xl text-gray-400 animate-spin">refresh</span>
                    <p class="text-gray-500 mt-2">{{ __('cargando_imagenes') }}...</p>
                </div>
                <div id="images-grid" class="hidden grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
                    <!-- Images will be loaded here -->
                </div>
                <div id="images-empty" class="hidden text-center py-8">
                    <span class="material-symbols-outlined text-4xl text-gray-400">image</span>
                    <p class="text-gray-500 mt-2">{{ __('sin_imagen') }}</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scriptsJS')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="{{ asset('js/CRUD.js') }}"></script>
<script>
$(document).ready(function() {
    const instalacionId = $('#instalacion_id').val();
    const form = $('#hpinstalacion-form');

    function formatColor(option) {
        if (!option.id) return option.text; // Placeholder
        const color = $(option.element).data("color") || "#000000";
        return $(`
            <span class="flex items-center gap-2">
                <span class="inline-block w-4 h-4 rounded-full border" style="background:${color};"></span>
                <span>${option.text}</span>
            </span>`);
    }

    $(".select2-color").select2({
        width: "100%",
        placeholder: "Seleccione un color",
        templateResult: formatColor,
        templateSelection: formatColor,
        minimumResultsForSearch: -1 // oculta buscador
    });
    
    // Finalizar Instalación
    $('#btn-finalizar').on('click', function() {
        Swal.fire({
            title: '¿Finalizar Instalación?',
            text: "Si finaliza la instalación, NO podrá modificar los datos posteriormente.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#1f2937', // Gray-800 matches button
            cancelButtonColor: '#d33',
            confirmButtonText: 'Sí, finalizar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                // Set status to '3' (Finalizado) based on Catalogos
                $('#estado_instalacion').val('3');
                
                // Trigger existing submit handler
                form.submit();
            }
        });
    });

    // Manejar envío del formulario
    form.on('submit', function(e) {
        e.preventDefault();
        
        $('.text-red-500').addClass('hidden').text('');
        $('input, select').removeClass('border-red-500');
        // Resetear estilo de select2 container si hubiera error visual previo (opcional)
        
        const btn = $('#btn-guardar');
        const originalText = btn.html();
        btn.prop('disabled', true).html('<span class="material-symbols-outlined mr-2 animate-spin">refresh</span> Procesando...');

        const formData = form.serialize();

        // Usar CRUD.update o $.ajax directo
        $.ajax({
            url: "{{ url('/rhpinstalacion') }}/" + instalacionId,
            type: 'PUT',
            data: formData,
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: '¡Éxito!',
                        text: 'Instalación actualizada correctamente.',
                        showConfirmButton: false,
                        timer: 2000
                    }).then(() => {
                        window.location.href = "{{ url($urlList) }}";
                    });
                } else {
                    Swal.fire('Error', response.message || 'Error al actualizar.', 'error');
                    btn.prop('disabled', false).html(originalText);
                }
            },
            error: function(xhr) {
                btn.prop('disabled', false).html(originalText);
                
                if (xhr.status === 422) {
                    let errors = xhr.responseJSON.errors;
                    for (const key in errors) {
                        $(`#${key}`).addClass('border-red-500');
                        $(`#error-${key}`).text(errors[key][0]).removeClass('hidden');
                    }
                    Swal.fire({
                        icon: 'error',
                        title: 'Error de Validación',
                        text: 'Por favor revisa los campos marcados.'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: xhr.responseJSON?.message || 'Ocurrió un error inesperado.'
                    });
                }
            }
        });
    });

    // ========== IMAGE UPLOAD FUNCTIONALITY ==========
    
    // Load images on page load
    loadImages();

    function loadImages() {
        const instalacionId = $('#upload_instalacion_id').val();
        
        $.ajax({
            url: "{{ url('/rhpimagen') }}",
            type: 'GET',
            data: { id_hp_instalacion: instalacionId },
            success: function(response) {
                $('#images-loading').addClass('hidden');
                
                if (response.success && response.data.length > 0) {
                    $('#images-empty').addClass('hidden');
                    $('#images-grid').removeClass('hidden');
                    displayImages(response.data);
                } else {
                    $('#images-grid').addClass('hidden');
                    $('#images-empty').removeClass('hidden');
                }
            },
            error: function(xhr) {
                $('#images-loading').addClass('hidden');
                $('#images-empty').removeClass('hidden');
                console.error('Error loading images:', xhr);
            }
        });
    }

    function displayImages(images) {
        const grid = $('#images-grid');
        grid.empty();
        
        images.forEach(function(imagen) {
            const imageUrl = "{{ asset('assets/images/jobs') }}/" + imagen.nombre_imagen;
            const card = $(`
                <div class="relative bg-white border border-gray-200 rounded-lg overflow-hidden shadow-sm hover:shadow-md transition-shadow group">
                    <img src="${imageUrl}" alt="Imagen ${imagen.id}" class="w-full h-48 object-cover">
                    <div class="absolute inset-0 bg-black opacity-0 group-hover:opacity-50 transition-opacity duration-200 pointer-events-none"></div>
                    <div class="absolute inset-0 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-200">
                        <button type="button" onclick="deleteImage(${imagen.id})" 
                                class="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700 flex items-center z-10">
                            <span class="material-symbols-outlined text-sm mr-1">delete</span>
                            Eliminar
                        </button>
                    </div>
                    <div class="p-2 text-xs text-gray-500 text-center truncate bg-white">
                        ${imagen.nombre_imagen}
                    </div>
                </div>
            `);
            grid.append(card);
        });
    }

    function addImageToGrid(imagen) {
        // Show grid if it was hidden (first image)
        if ($('#images-grid').hasClass('hidden')) {
            $('#images-empty').addClass('hidden');
            $('#images-grid').removeClass('hidden');
        }
        
        const imageUrl = "{{ asset('assets/images/jobs') }}/" + imagen.nombre_imagen;
        const card = $(`
            <div class="relative bg-white border border-gray-200 rounded-lg overflow-hidden shadow-sm hover:shadow-md transition-shadow group animate-fade-in">
                <img src="${imageUrl}" alt="Imagen ${imagen.id}" class="w-full h-48 object-cover">
                <div class="absolute inset-0 bg-black opacity-0 group-hover:opacity-50 transition-opacity duration-200 pointer-events-none"></div>
                <div class="absolute inset-0 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-200">
                    <button type="button" onclick="deleteImage(${imagen.id})" 
                            class="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700 flex items-center z-10">
                        <span class="material-symbols-outlined text-sm mr-1">delete</span>
                        Eliminar
                    </button>
                </div>
                <div class="p-2 text-xs text-gray-500 text-center truncate bg-white">
                    ${imagen.nombre_imagen}
                </div>
            </div>
        `);
        
        // Prepend to show newest images first
        $('#images-grid').prepend(card);
    }

    // Handle image preview
    $('#imagen').on('change', function(e) {
        const file = this.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                $('#preview-img').attr('src', e.target.result);
                $('#image-preview').removeClass('hidden');
                $('#drop-zone-content').addClass('hidden');
            }
            reader.readAsDataURL(file);
        }
    });

    // Remove preview
    $('#remove-preview').on('click', function(e) {
        e.preventDefault(); // Prevent opening file dialog
        e.stopPropagation(); // Stop propagation to container
        $('#imagen').val(''); // Clear input
        $('#image-preview').addClass('hidden');
        $('#preview-img').attr('src', '#');
        $('#drop-zone-content').removeClass('hidden');
    });

    // Handle image upload
    $('#upload-form').on('submit', function(e) {
        e.preventDefault();
        
        const fileInput = $('#imagen')[0];
        if (!fileInput.files || fileInput.files.length === 0) {
            Swal.fire('Error', 'Por favor seleccione una imagen.', 'error');
            return;
        }

        const formData = new FormData();
        formData.append('imagen', fileInput.files[0]);
        formData.append('id_hp_instalacion', $('#upload_instalacion_id').val());
        formData.append('descripcion', $('#descripcion').val());
        formData.append('_token', $('input[name="_token"]').val());

        const uploadBtn = $('#btn-upload');
        const originalText = uploadBtn.html();
        uploadBtn.prop('disabled', true).html('<span class="material-symbols-outlined mr-2 animate-spin">refresh</span> Subiendo...');
        
        $('#upload-progress').removeClass('hidden');
        $('#progress-bar').css('width', '0%');
        $('#upload-status').text('Iniciando subida...');

        $.ajax({
            url: "{{ url('/rhpimagen/upload') }}",
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            xhr: function() {
                const xhr = new window.XMLHttpRequest();
                xhr.upload.addEventListener('progress', function(e) {
                    if (e.lengthComputable) {
                        const percentComplete = (e.loaded / e.total) * 100;
                        $('#progress-bar').css('width', percentComplete + '%');
                        $('#upload-status').text(`Subiendo... ${Math.round(percentComplete)}%`);
                    }
                }, false);
                return xhr;
            },
            success: function(response) {
                if (response.success) {
                    $('#upload-status').text('¡Imagen subida exitosamente!');
                    
                    // Add the new image to the grid immediately without reloading
                    addImageToGrid(response.data);
                    
                    // Show success toast instead of blocking alert
                    $.showSimpleToast('Imagen subida correctamente.', 'success', 3000);
                    
                    // Reset form and hide progress
                    $('#upload-form')[0].reset();
                    setTimeout(function() {
                        $('#upload-progress').addClass('hidden');
                    }, 1000);
                } else {
                    Swal.fire('Error', response.message || 'Error al subir imagen.', 'error');
                }
            },
            error: function(xhr) {
                let errorMsg = 'Error al subir la imagen.';
                if (xhr.status === 422 && xhr.responseJSON && xhr.responseJSON.errors) {
                    const errors = xhr.responseJSON.errors;
                    errorMsg = Object.values(errors).flat().join('<br>');
                } else if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMsg = xhr.responseJSON.message;
                }
                
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    html: errorMsg
                });
                $('#upload-status').text('Error en la subida');
            },
            complete: function() {
                uploadBtn.prop('disabled', false).html(originalText);
            }
        });
    });

    // Delete image function (global scope for onclick)
    window.deleteImage = function(imageId) {
        Swal.fire({
            title: '¿Eliminar imagen?',
            text: 'Esta acción no se puede deshacer',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ url('/rhpimagen') }}/" + imageId,
                    type: 'DELETE',
                    data: {
                        _token: $('input[name="_token"]').val()
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Eliminada',
                                text: 'Imagen eliminada correctamente.',
                                showConfirmButton: false,
                                timer: 2000
                            });
                            loadImages();
                        } else {
                            Swal.fire('Error', response.message || 'Error al eliminar.', 'error');
                        }
                    },
                    error: function(xhr) {
                        Swal.fire('Error', 'No se pudo eliminar la imagen.', 'error');
                    }
                });
            }
        });
    };
});
</script>
@endsection
