@extends('master')

@section('stylesCSS')
@endsection

@section('headerContent')
<h5 class="!mb-0">
    Mis Asignaciones
</h5>
<ol class="breadcrumb mt-[12px] md:mt-0">
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        <a href="/main" class="inline-block relative ltr:pl-[22px] rtl:pr-[22px] transition-all hover:text-primary-500">
            <i class="material-symbols-outlined absolute ltr:left-0 rtl:right-0 !text-lg -mt-px text-primary-500 top-1/2 -translate-y-1/2">home</i>
            Dashboard
        </a>
    </li>
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        Trabajos Asignados
    </li>
</ol>
@endsection

@section('titleContent')
<h3 class="!mb-0">
    Lista de Trabajos Asignados
</h3>
@endsection

@section('bodyContent')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="trezo-card p-6">
        
        @if($hpinstalacion->isEmpty())
            <div class="text-center py-12">
                <span class="material-symbols-outlined text-6xl text-gray-400">assignment</span>
                <p class="text-gray-500 mt-4 text-lg">No tienes trabajos asignados en este momento.</p>
            </div>
        @else
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @foreach($hpinstalacion as $instalacion)
                    <div class="bg-white border border-gray-200 rounded-lg shadow-sm hover:shadow-md transition-shadow duration-200">
                        <div class="p-6">
                            <!-- Header -->
                            <div class="flex items-start justify-between mb-4">
                                <div class="flex-1">
                                    <h4 class="text-lg font-semibold text-gray-800">
                                        Casa #{{ $instalacion->numero ?? 'N/A' }}
                                    </h4>
                                    <p class="text-sm text-gray-500">
                                        {{ $instalacion->nombre_calle ?? 'Sin calle' }}
                                    </p>
                                </div>
                                <span class="px-3 py-1 text-xs font-medium rounded-full bg-{{ $instalacion->nombre_color }}-100 text-{{ $instalacion->nombre_color }}-800">
                                    {{ $instalacion->nombre_estado_instalacion }}
                                </span>
                            </div>

                            <!-- Details -->
                            <div class="space-y-2 mb-4">
                                <div class="flex items-center text-sm text-gray-600">
                                    <span class="material-symbols-outlined text-base mr-2">location_on</span>
                                    <span>{{ $instalacion->nombre_ubicacion ?? 'Sin ubicación' }}</span>
                                </div>
                                <div class="flex items-center text-sm text-gray-600">
                                    <span class="material-symbols-outlined text-base mr-2">mail</span>
                                    <span>CP: {{ $instalacion->nombre_codigo_postal ?? 'N/A' }}</span>
                                </div>
                                @if($instalacion->persona_nombre)
                                    <div class="flex items-center text-sm text-gray-600">
                                        <span class="material-symbols-outlined text-base mr-2">person</span>
                                        <span>{{ $instalacion->nombre_persona }}</span>
                                    </div>
                                @endif
                            </div>

                            <!-- Action Button -->
                            <div class="pt-4 border-t border-gray-200">
                                @if($instalacion->estado_instalacion == '3')
                                <a href="{{ url('/dashboard/informejob/'.$instalacion->id) }}" target="_blank" rel="noopener noreferrer" class="w-full inline-flex items-center justify-center gap-2 px-4 py-2 bg-red-50 text-red-700 border border-red-200 rounded-md hover:bg-red-100 hover:text-red-800 transition-colors">
                                    <span class="material-symbols-outlined text-sm mr-2">picture_as_pdf</span> 
                                    Informe PDF
                                </a>
                                @else
                                <a href="{{ url('/dashboard/hpinstalacionjob/' . $instalacion->id . '/edit') }}" 
                                   class="w-full inline-flex items-center justify-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-md hover:bg-blue-700 transition-colors">
                                    <span class="material-symbols-outlined text-sm mr-2">edit</span>
                                    Procesar Trabajo
                                </a>
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif

    </div>
</div>
@endsection

@section('scriptsJS')
<script>
$(document).ready(function() {
    // Aquí puedes agregar funcionalidad adicional si es necesario
    console.log('Lista de trabajos cargada');
});
</script>
@endsection
