@extends('master')

@section('stylesCSS')
@endsection

@section('headerContent')
<h5 class="!mb-0">
    Mis Asignaciones
</h5>
<ol class="breadcrumb mt-[12px] md:mt-0">
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        <a href="/main" class="inline-block relative ltr:pl-[22px] rtl:pr-[22px] transition-all hover:text-primary-500">
            <i class="material-symbols-outlined absolute ltr:left-0 rtl:right-0 !text-lg -mt-px text-primary-500 top-1/2 -translate-y-1/2">home</i>
            Dashboard
        </a>
    </li>
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        Trabajos Asignados
    </li>
</ol>
@endsection

@section('titleContent')
<div class="mb-8">
    <h1 class="text-3xl font-bold text-gray-800">Mi Perfil</h1>
    <p class="text-gray-600">Administra tu información personal y de cuenta.</p>
</div>
@endsection

@section('bodyContent')
<div class="container mx-auto px-4 py-1">
    <div class="max-w-4xl mx-auto">
        <!-- Header -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <!-- Sidebar / Profile Card -->
            <div class="md:col-span-1">
                <div class="bg-white rounded-xl shadow-lg p-6 text-center border border-gray-100">
                    <div class="relative inline-block mb-4 group">
                        <img id="profile-image-preview" 
                             src="{{ $persona_usuario->fotografia && $persona_usuario->fotografia != 'default.jpg' ? asset('assets/images/users/' . $persona_usuario->fotografia) : 'https://ui-avatars.com/api/?name=' . urlencode($persona_usuario->nombre . ' ' . $persona_usuario->paterno) . '&background=random' }}" 
                             alt="Avatar" 
                             class="w-32 h-32 rounded-full object-cover border-4 border-indigo-50 shadow-md mx-auto transition-transform duration-300 group-hover:scale-105">
                        <div class="absolute bottom-0 right-0 bg-indigo-600 rounded-full p-2 cursor-pointer hover:bg-indigo-700 transition" onclick="document.getElementById('fotografia_file').click()">
                            <span class="material-symbols-outlined text-white text-sm">photo_camera</span>
                        </div>
                    </div>
                    
                    <h2 class="text-xl font-bold text-gray-800">{{ $persona_usuario->nombre }} {{ $persona_usuario->paterno }}</h2>
                    <p class="text-gray-500 text-sm mb-4">{{ $persona_usuario->rol_nombre ?? 'Usuario' }}</p>

                    <div class="mt-4 pt-4 border-t border-gray-100 text-left">
                        <div class="mb-2">
                            <span class="text-xs text-gray-400 uppercase font-semibold">DNI/CI</span>
                            <p class="text-gray-700 font-medium">{{ $persona_usuario->dni }}</p>
                        </div>
                        <div>
                            <span class="text-xs text-gray-400 uppercase font-semibold">Fecha Registro</span>
                            <p class="text-gray-700 font-medium">{{ \Carbon\Carbon::parse($persona_usuario->created_at)->format('d M, Y') }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Forms Section -->
            <div class="md:col-span-2 space-y-6">
                
                <!-- Personal Information -->
                <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
                    <div class="bg-indigo-50 px-6 py-2 border-b border-indigo-100 flex items-center">
                        <span class="material-symbols-outlined text-indigo-600 mr-2">person</span>
                        <h3 class="font-semibold text-indigo-900">Información Personal</h3>
                    </div>
                    <div class="p-6">
                        <form id="form-personal-info" enctype="multipart/form-data">
                            @csrf
                            <input type="file" id="fotografia_file" name="fotografia_file" class="hidden" accept="image/*">
                            
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Dirección</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="material-symbols-outlined text-gray-400 text-lg">home</span>
                                        </div>
                                        <input type="text" name="direccion" value="{{ $persona_usuario->direccion }}" 
                                               class="pl-10 w-full rounded-lg border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 transition shadow-sm"
                                               placeholder="Tu dirección actual">
                                    </div>
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Teléfono Celular</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="material-symbols-outlined text-gray-400 text-lg">smartphone</span>
                                        </div>
                                        <input type="text" name="telefono_celular" value="{{ $persona_usuario->telefono_celular }}" 
                                               class="pl-10 w-full rounded-lg border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 transition shadow-sm"
                                               placeholder="Número de celular">
                                    </div>
                                </div>
                            </div>

                            <div class="mt-6 flex justify-end">
                                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-medium py-2 px-6 rounded-lg shadow transition duration-200 flex items-center">
                                    <span class="material-symbols-outlined mr-2 text-sm">save</span>
                                    Guardar Cambios
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Account Information -->
                <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
                    <div class="bg-gray-50 px-6 py-2 border-b border-gray-100 flex items-center">
                        <span class="material-symbols-outlined text-gray-600 mr-2">manage_accounts</span>
                        <h3 class="font-semibold text-gray-900">Cuenta de Usuario</h3>
                    </div>
                    <div class="p-6">
                        <div class="space-y-6">
                            <!-- Email Update -->
                            <form id="form-account-email">
                                @csrf
                                <label class="block text-sm font-medium text-gray-700 mb-1">Correo Electrónico</label>
                                <div class="flex gap-2">
                                    <div class="relative flex-grow">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="material-symbols-outlined text-gray-400 text-lg">mail</span>
                                        </div>
                                        <input type="email" name="email" value="{{ $persona_usuario->email }}" 
                                               class="pl-10 w-full rounded-lg border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 transition shadow-sm"
                                               placeholder="correo@ejemplo.com">
                                    </div>
                                    <button type="submit" class="bg-gray-800 hover:bg-gray-900 text-white font-medium px-4 rounded-lg shadow transition duration-200 flex items-center">
                                        <span class="material-symbols-outlined text-sm">save</span>
                                    </button>
                                </div>
                            </form>

                            <hr class="border-gray-100">

                            <!-- Password Section -->
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-sm font-medium text-gray-700">Contraseña</p>
                                    <p class="text-xs text-gray-500">Es recomendable cambiar tu contraseña periódicamente.</p>
                                </div>
                                <button type="button" onclick="openPasswordModal()" class="border border-indigo-200 bg-indigo-50 text-indigo-700 hover:bg-indigo-100 font-medium py-2 px-4 rounded-lg transition duration-200 flex items-center">
                                    <span class="material-symbols-outlined mr-2 text-sm">key</span>
                                    Cambiar Contraseña
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Password Change Modal -->
<div id="passwordModal" class="fixed inset-0 hidden overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:block sm:p-0">
        <!-- Backdrop -->
        <div class="fixed inset-0 bg-gray-900/40 backdrop-blur-sm transition-opacity" aria-hidden="true" onclick="closePasswordModal()"></div>
        
        <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
        
        <!-- Modal Panel -->
        <div class="inline-block align-bottom bg-white rounded-3xl text-left overflow-hidden shadow-2xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full relative z-[100000]">
            <!-- Header (Soft & Elegant) -->
            <div class="bg-gray-50 border-b border-gray-100 px-4 py-2 sm:px-6">
                <div class="flex items-center justify-between text-gray-800">
                    <div class="flex items-center space-x-3">
                        <div class="p-2 bg-white rounded-full shadow-sm ring-1 ring-gray-200">
                            <span class="material-symbols-outlined text-2xl text-indigo-500">lock_reset</span>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold leading-6 text-gray-900" id="modal-title">Cambiar Contraseña</h3>
                            <p class="text-gray-500 text-sm mt-1">Protege tu cuenta con una clave segura</p>
                        </div>
                    </div>
                    <button type="button" onclick="closePasswordModal()" class="text-gray-400 hover:text-gray-600 transition-colors bg-white rounded-full p-1 hover:bg-gray-100">
                        <span class="material-symbols-outlined">close</span>
                    </button>
                </div>
            </div>

            <div class="px-4 py-6 sm:px-6">
                <form id="form-change-password">
                    @csrf
                    <div class="space-y-4">
                        <!-- Current Password -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Contraseña Actual</label>
                            <div class="relative group">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400 group-focus-within:text-indigo-500 transition-colors">vpn_key</span>
                                </div>
                                <input type="password" name="current_password" id="current_password"
                                       class="block w-full pl-10 pr-3 py-3 border border-gray-200 rounded-xl leading-5 bg-gray-50 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 focus:bg-white transition-all duration-200 sm:text-sm"
                                       placeholder="••••••••">
                            </div>
                        </div>

                        <!-- New and Confirm Password -->
                        <div class="grid grid-cols-1 gap-6 sm:grid-cols-2">
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Nueva Contraseña</label>
                                <div class="relative group">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <span class="material-symbols-outlined text-gray-400 group-focus-within:text-indigo-500 transition-colors">lock</span>
                                    </div>
                                    <input type="password" name="new_password" id="new_password"
                                           class="block w-full pl-10 pr-3 py-3 border border-gray-200 rounded-xl leading-5 bg-gray-50 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 focus:bg-white transition-all duration-200 sm:text-sm"
                                           placeholder="Nueva clave">
                                </div>
                                <div id="error-new_password" class="text-red-500 text-xs mt-1 ml-1 hidden font-medium"></div>
                            </div>

                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Confirmar</label>
                                <div class="relative group">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <span class="material-symbols-outlined text-gray-400 group-focus-within:text-indigo-500 transition-colors">check_circle</span>
                                    </div>
                                    <input type="password" name="new_password_confirmation" id="new_password_confirmation"
                                           class="block w-full pl-10 pr-3 py-3 border border-gray-200 rounded-xl leading-5 bg-gray-50 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 focus:bg-white transition-all duration-200 sm:text-sm"
                                           placeholder="Repetir clave">
                                </div>
                                <div id="error-new_password_confirmation" class="text-red-500 text-xs mt-1 ml-1 hidden font-medium"></div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Footer Actions -->
            <div class="bg-gray-50 px-4 py-4 sm:px-6 flex flex-row-reverse gap-3 border-t border-gray-100">
                <button type="button" id="btn-save-password"
                    class="inline-flex w-full justify-center items-center rounded-xl border border-transparent 
                        bg-indigo-400 hover:bg-indigo-500 
                        px-5 py-3 text-sm font-semibold text-white shadow-sm
                        focus:outline-none focus:ring-2 focus:ring-indigo-400 focus:ring-offset-2
                        transition-all duration-200 sm:w-auto">
                    <span class="material-symbols-outlined text-lg mr-2">save_as</span>
                    Actualizar
                </button>
                <button type="button" onclick="closePasswordModal()" class="inline-flex w-full justify-center items-center rounded-xl border border-transparent bg-white px-5 py-3 text-sm font-semibold text-gray-700 shadow-sm hover:bg-gray-50 hover:text-gray-900 border-gray-200 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition-all duration-200 sm:w-auto">
                    Cancelar
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scriptsJS')
<script>
    function openPasswordModal() {
        $('#passwordModal').removeClass('hidden');
        $('#form-change-password')[0].reset();
        $('#password-match-error').addClass('hidden');
    }

    function closePasswordModal() {
        $('#passwordModal').addClass('hidden');
    }

    $(document).ready(function() {
        // Image Preview on file select
        $('#fotografia_file').change(function(e) {
            if (this.files && this.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#profile-image-preview').attr('src', e.target.result);
                }
                reader.readAsDataURL(this.files[0]);
            }
        });

        // Update Personal Info
        $('#form-personal-info').on('submit', function(e) {
            e.preventDefault();
            var formData = new FormData(this);

            $.ajax({
                url: "{{ url('rpersona/updateProfile') }}", // Using url() helper as per routes
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function(response) {
                    if(response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: '¡Éxito!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                           // location.reload(); // Optional: reload to refresh all data if needed
                        });
                    }
                },
                error: function(xhr) {
                    var errors = xhr.responseJSON?.errors;
                    var errorMessage = xhr.responseJSON?.message || 'Ocurrió un error.';
                    if(errors) {
                         errorMessage += '\n' + Object.values(errors).join('\n');
                    }
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: errorMessage
                    });
                }
            });
        });

        // Update Account Email
        $('#form-account-email').on('submit', function(e) {
            e.preventDefault();
            var formData = $(this).serialize();

            $.ajax({
                url: "{{ url('rusuario/updateProfileEmail') }}",
                type: 'POST',
                data: formData,
                success: function(response) {
                    if(response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: '¡Email Actualizado!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        });
                    }
                },
                error: function(xhr) {
                    var errors = xhr.responseJSON?.errors;
                    var errorMessage = xhr.responseJSON?.message || 'Ocurrió un error.';
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: errorMessage
                    });
                }
            });
        });

        // Helper functions for inline errors
        function showInputError(fieldId, message) {
            $(`#${fieldId}`).addClass('border-red-500 focus:border-red-500 focus:ring-red-500').removeClass('border-gray-200');
            $(`#error-${fieldId}`).text(message).removeClass('hidden');
        }

        function clearInputErrors() {
            ['current_password', 'new_password', 'new_password_confirmation'].forEach(field => {
                $(`#${field}`).removeClass('border-red-500 focus:border-red-500 focus:ring-red-500').addClass('border-gray-200');
                $(`#error-${field}`).addClass('hidden').text('');
            });
        }

        // Save Password
        $('#btn-save-password').click(function() {
            clearInputErrors();
            let hasError = false;

            const current = $('#current_password').val();
            const newPass = $('#new_password').val();
            const confirm = $('#new_password_confirmation').val();

            // Client-side validation
            if (!current) {
                showInputError('current_password', 'La contraseña actual es obligatoria.');
                hasError = true;
            }

            if (!newPass) {
                showInputError('new_password', 'La nueva contraseña es obligatoria.');
                hasError = true;
            } else if (newPass.length < 8) {
                showInputError('new_password', 'La contraseña debe tener al menos 8 caracteres.');
                hasError = true;
            }

            if (!confirm) {
                showInputError('new_password_confirmation', 'Debes confirmar la contraseña.');
                hasError = true;
            } else if (newPass !== confirm) {
                showInputError('new_password_confirmation', 'Las contraseñas no coinciden.');
                hasError = true;
            }

            if (hasError) return;

            var formData = $('#form-change-password').serialize();
            
            // Disable button
            $('#btn-save-password').prop('disabled', true).addClass('opacity-75 cursor-not-allowed');

            $.ajax({
                url: "{{ url('rusuario/updateProfilePassword') }}",
                type: 'POST',
                data: formData,
                success: function(response) {
                    $('#btn-save-password').prop('disabled', false).removeClass('opacity-75 cursor-not-allowed');
                    if(response.success) {
                        closePasswordModal();
                        Swal.fire({
                            icon: 'success',
                            title: '¡Contraseña Actualizada!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        });
                        $('#form-change-password')[0].reset();
                    }
                },
                error: function(xhr) {
                    $('#btn-save-password').prop('disabled', false).removeClass('opacity-75 cursor-not-allowed');
                    var errors = xhr.responseJSON?.errors;
                    
                    if (errors) {
                        // Map server errors to inputs
                        if (errors.current_password) showInputError('current_password', errors.current_password[0]);
                        if (errors.new_password) showInputError('new_password', errors.new_password[0]);
                        if (errors.new_password_confirmation) showInputError('new_password_confirmation', errors.new_password_confirmation[0]);

                        // Check for unrelated errors
                        const fieldErrors = ['current_password', 'new_password', 'new_password_confirmation'];
                        const otherErrors = Object.keys(errors).filter(k => !fieldErrors.includes(k));
                        
                        if(otherErrors.length > 0) {
                             Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'Error en la validación de datos.'
                            });
                        }
                    } else {
                         Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: xhr.responseJSON?.message || 'Ocurrió un error inesperado.'
                        });
                    }
                }
            });
        });
    });
</script>
@endsection
