@extends('master')

@section('stylesCSS')
    <link rel="stylesheet" href="https://cdn.datatables.net/2.3.5/css/dataTables.tailwindcss.css">
@endsection

@section('headerContent')
<h5 class="!mb-0">
    Gestión de Personas
</h5>
<ol class="breadcrumb mt-[12px] md:mt-0">
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        <a href="/main" class="inline-block relative ltr:pl-[22px] rtl:pr-[22px] transition-all hover:text-primary-500">
            <i class="material-symbols-outlined absolute ltr:left-0 rtl:right-0 !text-lg -mt-px text-primary-500 top-1/2 -translate-y-1/2">home</i>
            Dashboard
        </a>
    </li>
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        Personas
    </li>
</ol>
@endsection

@section('titleContent')
<h3 class="!mb-0">
    Listado de Equipos
</h3>
@endsection

@section('bodyContent')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="trezo-card p-5">
        <div class="flex justify-between items-center mb-4">
            <h2 class="text-xl font-bold text-gray-700">Equipos Registrados</h2>
            <div class="flex items-center space-x-2">
                <a href="{{ url('/dashboard/persona/new') }}" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg shadow-md transition duration-300 flex items-center">
                    <i class="material-symbols-outlined mr-2">add</i> Nuevo
                </a>
            </div>
        </div>

        <!-- Tabla de Personas -->
        <div class="overflow-x-auto bg-white rounded-lg shadow">
            <table id="personas-table" class="min-w-full leading-normal">
                <thead class="bg-gray-200 text-gray-600 uppercase text-sm">
                    <tr>
                        <th class="px-5 py-3 border-b-2 border-gray-200 text-left">ID</th>
                        <th class="px-5 py-3 border-b-2 border-gray-200 text-left">DNI</th>
                        <th class="px-5 py-3 border-b-2 border-gray-200 text-left">Nombre Completo</th>
                        <th class="px-5 py-3 border-b-2 border-gray-200 text-left">Email</th>
                        <th class="px-5 py-3 border-b-2 border-gray-200 text-center">Estado</th>
                        <th class="px-5 py-3 border-b-2 border-gray-200 text-center">Acciones</th>
                    </tr>
                </thead>
                <tbody class="text-gray-700">
                    <!-- Los datos se cargarán aquí vía AJAX -->
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@section('scriptsJS')
<script src="https://cdn.datatables.net/2.3.5/js/dataTables.js"></script>
<script src="https://cdn.datatables.net/2.3.5/js/dataTables.tailwindcss.js"></script>
<script src="{{ asset('js/CRUD.js') }}"></script>

<script>
$(document).ready(function() {
    const table = $('#personas-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('rpersona.index') }}",
        columns: [
            { data: 'id', name: 'id' },
            { data: 'dni', name: 'dni' },
            { data: 'nombre_completo', name: 'nombre_completo' },
            { data: 'email', name: 'email' },
            { 
                data: 'estado_usuario', 
                name: 'estado_usuario',
                render: function(data) {
                    return data === 'S' 
                        ? '<span class="bg-green-100 text-green-800 text-xs font-medium mr-2 px-2.5 py-0.5 rounded">Activo</span>'
                        : '<span class="bg-red-100 text-red-800 text-xs font-medium mr-2 px-2.5 py-0.5 rounded">Inactivo</span>';
                },
                className: 'text-center'
            },
            { data: 'action', name: 'action', orderable: false, searchable: false, className: 'text-center' }
        ],
        dom: '<"flex justify-between items-center mb-4"lf><"overflow-x-auto"rt><"flex justify-between items-center mt-4"ip>',
        initComplete: function () {
            const wrapper = this.api().table().container().closest('.dataTables_wrapper');
            $(wrapper).find('div.dataTables_filter input')
                .addClass('px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-1 focus:ring-blue-400 focus:border-blue-400 text-sm')
                .attr('placeholder', '🔍 Buscar...');
            $(wrapper).find('div.dataTables_length select')
                .addClass('px-2 py-1 border border-gray-300 rounded-md text-sm bg-white');
        },
        drawCallback: function () {
            const wrapper = this.api().table().container().closest('.dataTables_wrapper');
            const paginate = $(wrapper).find('div.dataTables_paginate');
            paginate.find('a.paginate_button').removeClass().addClass(
                'px-3 py-1 border border-gray-300 rounded-md text-sm transition-colors duration-200 cursor-pointer bg-gray-50 text-gray-700 hover:bg-blue-100 hover:text-blue-800'
            );
            paginate.find('a.paginate_button.current')
                .removeClass('bg-gray-50 text-gray-700 hover:bg-blue-100 hover:text-blue-800').addClass(
                    'px-3 py-1 border rounded-md text-sm bg-blue-600 text-white border-blue-600 cursor-pointer'
            );
            paginate.find('a.paginate_button.disabled').addClass('opacity-50 cursor-not-allowed');
            $('#personas-table tbody tr td').addClass('py-3 px-5 border-b border-gray-200 whitespace-nowrap');
        }
    });

    // Eliminar
    $('#personas-table tbody').on('click', '.btn-eliminar', function() {
        let id = $(this).data('id');
        Swal.fire({
            title: '¿Estás seguro?',
            text: "¡No podrás revertir esta acción!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Sí, ¡eliminar!',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                CRUD.delete("{{ url('/rpersona') }}", id).then(function(response) {
                    if (response.success) {
                        table.ajax.reload();
                        Swal.fire('¡Eliminado!', response.message, 'success');
                    }
                }).fail(function(xhr) {
                    let message = 'Ocurrió un error al eliminar.';
                    if (xhr.status === 409) message = xhr.responseJSON.message;
                    Swal.fire('Error', message, 'error');
                });
            }
        });
    });

    // Editar
    $('#personas-table tbody').on('click', '.btn-editar', function() {
        let id = $(this).data('id');
        window.location.href = "{{ url('/dashboard/persona') }}/" + id + "/edit";
    });
});
</script>
@endsection
