@extends('master')

@section('headerContent')
<h5 class="!mb-0">
    Nuevo Equipo
</h5>
<ol class="breadcrumb mt-[12px] md:mt-0">
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        <a href="/main" class="inline-block relative ltr:pl-[22px] rtl:pr-[22px] transition-all hover:text-primary-500">
            <i class="material-symbols-outlined absolute ltr:left-0 rtl:right-0 !text-lg -mt-px text-primary-500 top-1/2 -translate-y-1/2">home</i>
            Dashboard
        </a>
    </li>
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        <a href="{{ url('/dashboard/persona') }}" class="inline-block relative transition-all hover:text-primary-500">
            Equipos
        </a>
    </li>
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        Nuevo
    </li>
</ol>
@endsection

@section('titleContent')
<h3 class="!mb-0">
    Registro de Equipo (Encargado)
</h3>
@endsection

@section('bodyContent')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="max-w-5xl mx-auto">
        <form id="persona-usuario-form" autocomplete="off" class="space-y-8">
            @csrf
            
            <!-- SECCIÓN DATOS PERSONALES -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                <div class="bg-gray-50/50 px-8 py-6 border-b border-gray-100">
                    <div class="flex items-center gap-3">
                        <div class="bg-blue-100 p-2 rounded-lg text-blue-600">
                            <span class="material-symbols-outlined">person</span>
                        </div>
                        <div>
                            <h4 class="text-lg font-bold text-gray-800">Datos Personales</h4>
                            <p class="text-sm text-gray-500 mt-1">Información básica del encargado</p>
                        </div>
                    </div>
                </div>
                
                <div class="p-8">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                        <div>
                            <label for="dni" class="block text-sm font-semibold text-gray-700 mb-2">DNI *</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400">badge</span>
                                </div>
                                <input type="text" id="dni" name="dni" 
                                    class="pl-10 w-full rounded-lg border-gray-200 bg-gray-50 focus:bg-white focus:border-blue-500 focus:ring-blue-500 text-gray-800 transition-all outline-none py-2.5" 
                                    placeholder="Ingrese DNI" required>
                            </div>
                            <p id="error-dni" class="text-red-500 text-xs mt-1 hidden font-medium"></p>
                        </div>

                        <div>
                            <label for="nombre" class="block text-sm font-semibold text-gray-700 mb-2">Nombre *</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400">person_add</span>
                                </div>
                                <input type="text" id="nombre" name="nombre" 
                                    class="pl-10 w-full rounded-lg border-gray-200 bg-gray-50 focus:bg-white focus:border-blue-500 focus:ring-blue-500 text-gray-800 transition-all outline-none py-2.5" 
                                    placeholder="Nombres" required>
                            </div>
                            <p id="error-nombre" class="text-red-500 text-xs mt-1 hidden font-medium"></p>
                        </div>

                        <div>
                            <label for="paterno" class="block text-sm font-semibold text-gray-700 mb-2">Apellido Paterno *</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400">person</span>
                                </div>
                                <input type="text" id="paterno" name="paterno" 
                                    class="pl-10 w-full rounded-lg border-gray-200 bg-gray-50 focus:bg-white focus:border-blue-500 focus:ring-blue-500 text-gray-800 transition-all outline-none py-2.5" 
                                    placeholder="Apellido Paterno" required>
                            </div>
                            <p id="error-paterno" class="text-red-500 text-xs mt-1 hidden font-medium"></p>
                        </div>

                        <div>
                            <label for="materno" class="block text-sm font-semibold text-gray-700 mb-2">Apellido Materno</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400">person_outline</span>
                                </div>
                                <input type="text" id="materno" name="materno" 
                                    class="pl-10 w-full rounded-lg border-gray-200 bg-gray-50 focus:bg-white focus:border-blue-500 focus:ring-blue-500 text-gray-800 transition-all outline-none py-2.5" 
                                    placeholder="Apellido Materno">
                            </div>
                            <p id="error-materno" class="text-red-500 text-xs mt-1 hidden font-medium"></p>
                        </div>

                        <div>
                            <label for="telefono_celular" class="block text-sm font-semibold text-gray-700 mb-2">Celular</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400">phone_iphone</span>
                                </div>
                                <input type="text" id="telefono_celular" name="telefono_celular" 
                                    class="pl-10 w-full rounded-lg border-gray-200 bg-gray-50 focus:bg-white focus:border-blue-500 focus:ring-blue-500 text-gray-800 transition-all outline-none py-2.5" 
                                    placeholder="+51 900 000 000">
                            </div>
                            <p id="error-telefono_celular" class="text-red-500 text-xs mt-1 hidden font-medium"></p>
                        </div>

                        <div>
                            <label for="id_proyecto" class="block text-sm font-semibold text-gray-700 mb-2">Proyecto Asignado *</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400">apartment</span>
                                </div>
                                <select id="id_proyecto" name="id_proyecto" 
                                    class="pl-10 w-full rounded-lg border-gray-200 bg-gray-50 focus:bg-white focus:border-blue-500 focus:ring-blue-500 text-gray-800 transition-all outline-none py-2.5 appearance-none" 
                                    required>
                                    <option value="0">Seleccione un proyecto</option>
                                    @foreach ($proyectos as $d)
                                        <option value="{{ $d->id }}">{{ $d->nombre }}</option>
                                    @endforeach
                                </select>
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400 text-sm">expand_more</span>
                                </div>
                            </div>
                            <p id="error-id_proyecto" class="text-red-500 text-xs mt-1 hidden font-medium"></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- SECCIÓN DATOS USUARIO -->
            <input type="hidden" id="password" name="password" value="{{ $password }}">

            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                <div class="bg-gray-50/50 px-8 py-6 border-b border-gray-100">
                    <div class="flex items-center gap-3">
                        <div class="bg-purple-100 p-2 rounded-lg text-purple-600">
                            <span class="material-symbols-outlined">admin_panel_settings</span>
                        </div>
                        <div>
                            <h4 class="text-lg font-bold text-gray-800">Datos de Cuenta</h4>
                            <p class="text-sm text-gray-500 mt-1">Credenciales de acceso al sistema</p>
                        </div>
                    </div>
                </div>

                <div class="p-8">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                        <div>
                            <label for="clave_inicial" class="block text-sm font-semibold text-gray-700 mb-2">Clave Inicial</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400">key</span>
                                </div>
                                <input type="text" id="clave_inicial" name="clave_inicial" value="{{ $clave_inicial }}" 
                                    class="pl-10 w-full rounded-lg border-gray-200 bg-gray-100 text-gray-600 transition-all outline-none py-2.5 cursor-not-allowed" 
                                    readonly>
                            </div>
                            <p class="text-xs text-gray-500 mt-1.5 ml-1">Autogenerada por el sistema</p>
                            <p id="error-clave_inicial" class="text-red-500 text-xs mt-1 hidden font-medium"></p>
                        </div>

                        <div>
                            <label for="email_usuario" class="block text-sm font-semibold text-gray-700 mb-2">Correo Electrónico *</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400">mail</span>
                                </div>
                                <input type="email" id="email_usuario" name="email_usuario" 
                                    class="pl-10 w-full rounded-lg border-gray-200 bg-gray-50 focus:bg-white focus:border-blue-500 focus:ring-blue-500 text-gray-800 transition-all outline-none py-2.5" 
                                    placeholder="correo@ejemplo.com" required>
                            </div>
                            <p id="error-email_usuario" class="text-red-500 text-xs mt-1 hidden font-medium"></p>
                        </div>

                        <div>
                            <label for="id_rol" class="block text-sm font-semibold text-gray-700 mb-2">Rol del Sistema *</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400">verified_user</span>
                                </div>
                                <select name="id_rol" id="id_rol" 
                                    class="pl-10 w-full rounded-lg border-gray-200 bg-gray-50 focus:bg-white focus:border-blue-500 focus:ring-blue-500 text-gray-800 transition-all outline-none py-2.5 appearance-none"
                                    required>
                                    <option value="0">Seleccione un Rol</option>
                                    @foreach ($roles as $d)
                                        <option value="{{ $d->id }}">{{ $d->nombre }}</option>
                                    @endforeach
                                </select>
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <span class="material-symbols-outlined text-gray-400 text-sm">expand_more</span>
                                </div>
                            </div>
                            <p id="error-id_rol" class="text-red-500 text-xs mt-1 hidden font-medium"></p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex items-center justify-end gap-4 pt-4">
                <a href="{{ url('/dashboard/persona') }}" 
                    class="px-6 py-2.5 rounded-lg border border-gray-200 text-gray-600 hover:bg-gray-50 font-medium transition-colors">
                    Cancelar
                </a>
                <button type="submit" id="btn-guardar" 
                    class="px-6 py-2.5 rounded-lg bg-blue-600 text-white hover:bg-blue-700 font-medium shadow-md hover:shadow-lg transition-all flex items-center">
                    <span class="material-symbols-outlined mr-2 text-xl">save</span> 
                    Guardar Equipo
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

@section('scriptsJS')
<script src="{{ asset('js/CRUD.js') }}"></script>
<script>
$(document).ready(function() {
    $('#persona-usuario-form').on('submit', function(e) {
        e.preventDefault();
        
        // Limpiar errores previos
        $('.text-red-500').addClass('hidden').text('');
        $('input').removeClass('border-red-500');
        
        const btn = $('#btn-guardar');
        const originalText = btn.html();
        btn.prop('disabled', true).html('<span class="material-symbols-outlined mr-2 animate-spin">refresh</span> Procesando...');

        // 1. Recopilar datos de Persona
        // Nota: serializeArray obtiene todos, pero necesitamos separar para enviar a endpoints distintos
        // Ojo: email está en ambos, hay que tener cuidado.
        // En el form puse name="email" para persona y name="email_usuario" para usuario.
        
        let personaData = {
            id_proyecto: $('#id_proyecto').val(),
            dni: $('#dni').val(),
            nombre: $('#nombre').val(),
            paterno: $('#paterno').val(),
            materno: $('#materno').val(),
            email: $('#email_persona').val(),
            telefono_celular: $('#telefono_celular').val(),
            // Otros campos opcionales...
        };

        // 2. Crear Persona
        CRUD.create("{{ route('rpersona.store') }}", personaData)
            .then(function(responsePersona) {
                if (responsePersona.success) {
                    const personaId = responsePersona.data.id;
                    
                    // 3. Recopilar datos de Usuario
                    let usuarioData = {
                        id_persona: personaId,
                        clave_inicial: $('#clave_inicial').val(),
                        username: $('#email_usuario').val(),
                        email: $('#email_usuario').val(), // El controlador espera 'email'
                        password: $('#password').val(),
                        id_rol: $('#id_rol').val()
                    };
                    //alert($('#id_rol').val());                   
                    // 4. Crear Usuario
                    return CRUD.create("{{ route('rusuario.store') }}", usuarioData);
                } else {
                    throw new Error('Error al crear persona: ' + responsePersona.message);
                }
            })
            .then(function(responseUsuario) {
                if (responseUsuario.success) {
                    Swal.fire({
                        icon: 'success',
                        title: '¡Éxito!',
                        text: 'Persona y Usuario creados correctamente.',
                        showConfirmButton: false,
                        timer: 2000
                    }).then(() => {
                        window.location.href = "{{ url('/dashboard/persona') }}";
                    });
                }
            })
            .fail(function(xhr) {
                btn.prop('disabled', false).html(originalText);
                
                if (xhr.status === 422) {
                    let errors = xhr.responseJSON.errors;
                    // Mapear errores a campos
                    // Si el error viene de RUsuarioController, 'email' se refiere al email de usuario.
                    // Si viene de RPersonaController, 'email' es email de persona.
                    // Esto es un poco ambiguo visualmente, pero intentaremos mostrarlo.
                    
                    for (const key in errors) {
                        // Mapeo especial para email de usuario si falló en el segundo paso
                        let fieldId = key;
                        if (key === 'email') {
                            // Si ya pasamos la creación de persona (difícil de saber aquí sin más contexto, 
                            // pero si falló la persona, falló el primer request. Si falló usuario, es el segundo).
                            // Simplificación: si el valor del input email_usuario coincide con el error...
                            // Mejor: Asumimos que si falla RPersona, es #email_persona.
                            // Pero aquí estamos en el fail general.
                            // Una forma robusta es anidar los fails, pero por simplicidad:
                            
                            // Intentamos marcar ambos si hay duda, o mirar el contexto.
                            // Por ahora, marcaremos los campos que coincidan por ID.
                            if ($('#email_usuario').val() && xhr.responseJSON.message.includes('usuario')) { 
                                fieldId = 'email_usuario'; 
                            } else {
                                fieldId = 'email_persona'; // Default a persona si no es obvio
                            }
                        }
                        
                        // Ajuste para email_usuario que enviamos como 'email'
                        if (key === 'email' && $('#email_usuario').val() === JSON.parse(this.data || "{}").email) {
                             fieldId = 'email_usuario';
                        }

                        $(`#${fieldId}`).addClass('border-red-500');
                        $(`#error-${fieldId}`).text(errors[key][0]).removeClass('hidden');
                        
                        // Fallback por si no encuentra el ID exacto (ej. id_persona no está en el form visible)
                        if(key === 'id_persona') {
                            Swal.fire('Error', 'Error interno: No se pudo vincular la persona.', 'error');
                        }
                    }
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'Error de Validación',
                        text: 'Por favor revisa los campos marcados.'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: xhr.responseJSON?.message || 'Ocurrió un error inesperado.'
                    });
                }
            });
    });
});
</script>
@endsection
