@extends('master')

@section('stylesCSS')

@endsection

@section('headerContent')
<h5 class="!mb-0">
    Gestión de Personas
</h5>
<ol class="breadcrumb mt-[12px] md:mt-0">
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        <a href="/main" class="inline-block relative ltr:pl-[22px] rtl:pr-[22px] transition-all hover:text-primary-500">
            <i class="material-symbols-outlined absolute ltr:left-0 rtl:right-0 !text-lg -mt-px text-primary-500 top-1/2 -translate-y-1/2">home</i>
            Dashboard
        </a>
    </li>
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        Personas
    </li>
</ol>
@endsection

@section('titleContent')
<h3 class="!mb-0">
    Listado de Usuarios
</h3>
@endsection

@section('bodyContent')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="trezo-card p-5">
        <div class="flex justify-between items-center mb-4">
            <h2 class="text-xl font-bold text-gray-700">Usuarios Registrados</h2>
            <div class="flex items-center space-x-2">
                <a href="{{ url('/dashboard/usuario/new') }}" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg shadow-md transition duration-300 flex items-center">
                    <i class="material-symbols-outlined mr-2">add</i> Nuevo
                </a>
            </div>
        </div>

        <!-- Tabla de Personas -->
        <div class="overflow-x-auto bg-white rounded-lg shadow">
            <table id="personas-table" class="min-w-full leading-normal">
                <thead class="bg-gray-200 text-gray-600 uppercase text-sm">
                    <tr>
                        <th class="px-5 py-2 border-b-2 border-gray-200 text-left">ID</th>
                        <th class="px-5 py-2 border-b-2 border-gray-200 text-left">DNI</th>
                        <th class="px-5 py-2 border-b-2 border-gray-200 text-left">Fotografia</th>
                        <th class="px-5 py-2 border-b-2 border-gray-200 text-left">Nombre Completo</th>
                        <th class="px-5 py-2 border-b-2 border-gray-200 text-left">Email</th>
                        <th class="px-5 py-2 border-b-2 border-gray-200 text-left">Rol</th>
                        <th class="px-5 py-2 border-b-2 border-gray-200 text-left">Celular</th>
                        <th class="px-5 py-2 border-b-2 border-gray-200 text-center">Estado</th>
                        <th class="px-5 py-2 border-b-2 border-gray-200 text-center">Acciones</th>
                    </tr>
                </thead>
                <tbody class="text-gray-700">
                    @foreach ($usuarios as $usuario)
                        <tr>
                            <td class="px-5 py-2 border-b border-gray-200">{{ $loop->iteration }}</td>
                            <td class="px-5 py-2 border-b border-gray-200">{{ $usuario->dni }}</td>
                            <td class="px-5 py-2 border-b border-gray-200">
                                @if ($usuario->fotografia)
                                    <img src="{{ asset('assets/images/users/' . $usuario->fotografia) }}" alt="Fotografia" class="w-12 h-12 object-cover rounded-full">
                                @else
                                    <img src="{{ asset('assets/images/users/default.webp') }}" alt="Fotografia" class="w-12 h-12 object-cover rounded-full">
                                @endif
                            </td>
                            <td class="px-5 py-2 border-b border-gray-200">{{ $usuario->paterno }} {{ $usuario->materno }}, {{ $usuario->nombre }}</td>
                            <td class="px-5 py-2 border-b border-gray-200">{{ $usuario->email }}</td>
                            <td class="px-5 py-2 border-b border-gray-200">{{ $usuario->nombre_rol }}</td>
                            <td class="px-5 py-2 border-b border-gray-200">{{ $usuario->telefono_celular }}</td>
                            <td class="px-5 py-2 border-b border-gray-200">
                                @if ($usuario->estado_usuario == 'S')
                                    <span class="bg-green-500 text-white px-2 py-1 rounded">Activo</span>
                                @else
                                    <span class="bg-red-500 text-white px-2 py-1 rounded">Inactivo</span>
                                @endif
                            </td>
                            <td class="px-5 py-2 border-b border-gray-200">
                                <div class="flex space-x-2">
                                    <a href="{{ url('/dashboard/usuario/' . $usuario->id . '/edit') }}"
                                    class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg shadow-md transition duration-300 inline-flex items-center">
                                        <i class="material-symbols-outlined mr-1">edit</i>
                                    </a>

                                    <a href="{{ url('/dashboard/usuario/' . $usuario->id . '/reset') }}"
                                    class="bg-gray-900 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded-lg shadow-md transition duration-300 inline-flex items-center">
                                        <i class="material-symbols-outlined mr-1">lock_reset</i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @endforeach 
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@section('scriptsJS')

@endsection
