@extends('master')

@section('headerContent')
<h5 class="!mb-0">
    Cambiar Password
</h5>
<ol class="breadcrumb mt-[12px] md:mt-0">
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        <a href="/main" class="inline-block relative ltr:pl-[22px] rtl:pr-[22px] transition-all hover:text-primary-500">
            <i class="material-symbols-outlined absolute ltr:left-0 rtl:right-0 !text-lg -mt-px text-primary-500 top-1/2 -translate-y-1/2">home</i>
            Dashboard
        </a>
    </li>
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        <a href="{{ url('/dashboard/usuario') }}" class="inline-block relative transition-all hover:text-primary-500">
            Usuarios
        </a>
    </li>
    <li class="breadcrumb-item inline-block relative text-sm mx-[11px]">
        Reset Password
    </li>
</ol>
@endsection

@section('titleContent')
<h3 class="!mb-0">
    Reset Password
</h3>
@endsection

@section('bodyContent')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="max-w-6xl mx-auto">
        <form id="reset-password-form">
            @csrf
            <input type="hidden" id="usuario_id" value="{{ $usuario ? $usuario->id : '' }}">
            
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- SECCIÓN 1: DATOS DEL PERFIL (COLUMNA IZQUIERDA) -->
                <div class="lg:col-span-1">
                    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden h-full">
                        <div class="bg-gradient-to-br from-blue-50 to-indigo-50 px-6 py-6 border-b border-gray-100 flex flex-col items-center">
                            <div class="w-20 h-20 bg-white rounded-full flex items-center justify-center shadow-md mb-3 text-blue-600">
                                <span class="material-symbols-outlined text-4xl">account_circle</span>
                            </div>
                            <h4 class="text-lg font-bold text-gray-800">{{ $persona->nombre }}</h4>
                            <p class="text-sm text-gray-500 font-medium">{{ $usuario && $usuario->rol ? $usuario->rol->nombre : 'Sin Rol' }}</p>
                        </div>
                        
                        <div class="p-6 space-y-4">
                            <div>
                                <label class="text-xs font-semibold text-gray-400 uppercase tracking-wider mb-1 block">DNI</label>
                                <div class="flex items-center text-gray-700">
                                    <span class="material-symbols-outlined text-gray-400 mr-2 text-lg">badge</span>
                                    <span class="font-medium">{{ $persona->dni }}</span>
                                </div>
                            </div>
                            <div class="border-t border-gray-50"></div>
                            <div>
                                <label class="text-xs font-semibold text-gray-400 uppercase tracking-wider mb-1 block">Nombre Completo</label>
                                <div class="flex items-center text-gray-700">
                                    <span class="material-symbols-outlined text-gray-400 mr-2 text-lg">person</span>
                                    <span class="font-medium">{{ $persona->nombre }} {{ $persona->paterno }} {{ $persona->materno }}</span>
                                </div>
                            </div>
                            <div class="border-t border-gray-50"></div>
                            <div>
                                <label class="text-xs font-semibold text-gray-400 uppercase tracking-wider mb-1 block">Contacto</label>
                                <div class="flex items-center text-gray-700 mb-2">
                                    <span class="material-symbols-outlined text-gray-400 mr-2 text-lg">phone_iphone</span>
                                    <span class="font-medium">{{ $persona->telefono_celular ?? 'N/A' }}</span>
                                </div>
                                <div class="flex items-center text-gray-700">
                                    <span class="material-symbols-outlined text-gray-400 mr-2 text-lg">mail</span>
                                    <span class="font-medium truncate" title="{{ $usuario ? $usuario->email : 'N/A' }}">{{ $usuario ? $usuario->email : 'N/A' }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- SECCIÓN 2: ACCIÓN DE RESETEO (COLUMNA DERECHA) -->
                <div class="lg:col-span-2">
                    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                        <div class="px-8 py-6 border-b border-gray-100 bg-gray-50/30">
                            <div class="flex items-center gap-3">
                                <div class="bg-orange-100 p-2 rounded-lg text-orange-600">
                                    <span class="material-symbols-outlined">lock_reset</span>
                                </div>
                                <div>
                                    <h4 class="text-lg font-bold text-gray-800">Restablecer Contraseña</h4>
                                    <p class="text-sm text-gray-500">Genere y asigne una nueva clave de acceso provisional</p>
                                </div>
                            </div>
                        </div>

                        <div class="p-8">
                            <div class="mb-8">
                                <label for="password" class="block text-sm font-semibold text-gray-700 mb-3">Nueva Contraseña Generada *</label>
                                <div class="relative flex items-center">
                                    <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                        <span class="material-symbols-outlined text-gray-400">vpn_key</span>
                                    </div>
                                    <input type="text" id="password" name="password" value="{{ $nueva_clave ?? '' }}" 
                                        class="pl-11 pr-12 w-full h-14 rounded-xl border-2 border-gray-100 bg-gray-50 text-xl font-mono tracking-wider text-gray-800 focus:border-blue-500 focus:bg-white focus:ring-0 transition-all outline-none" 
                                        readonly>
                                    
                                    <div class="absolute inset-y-0 right-0 pr-2 flex items-center">
                                        <button type="button" id="btn-copy-password" class="p-2 text-gray-400 hover:text-blue-600 hover:bg-blue-50 rounded-lg transition-colors tooltip" title="Copiar al portapapeles">
                                            <span class="material-symbols-outlined text-xl">content_copy</span>
                                        </button>
                                    </div>
                                </div>
                                <p class="text-sm text-gray-500 mt-3 flex items-center">
                                    <span class="material-symbols-outlined text-base mr-1.5">info</span>
                                    Esta contraseña se guardará una vez haga clic en el botón de abajo.
                                </p>
                                <p id="error-password" class="text-red-500 text-xs mt-1 hidden font-medium"></p>
                            </div>

                            <div class="flex items-center justify-between pt-4 border-t border-gray-100">
                                <a href="{{ url('/dashboard/usuario') }}" 
                                    class="px-6 py-3 rounded-xl border border-gray-200 text-gray-600 hover:bg-gray-50 font-medium transition-colors flex items-center">
                                    <span class="material-symbols-outlined mr-2 text-lg">arrow_back</span> Cancelar
                                </a>
                                <button type="submit" id="btn-guardar" 
                                    class="px-8 py-3 rounded-xl bg-gradient-to-r from-blue-600 to-indigo-600 text-white hover:shadow-lg hover:from-blue-700 hover:to-indigo-700 font-bold tracking-wide transition-all shadow-md flex items-center">
                                    <span class="material-symbols-outlined mr-2 text-xl">save_as</span> 
                                    Confirmar Cambio
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@section('scriptsJS')
<script>
$(document).ready(function() {
    $('#btn-copy-password').on('click', function() {
        var password = document.getElementById("password").value;
        
        // Crear un elemento temporal input
        var $temp = $("<input>");
        $("body").append($temp);
        $temp.val(password).select();
        
        // Ejecutar comando de copiado
        try {
            document.execCommand("copy");
        } catch (err) {
            console.error('Error al copiar', err);
        }
        
        // Eliminar elemento temporal
        $temp.remove();

        // Mostrar alerta verificando si Swal existe
        if (typeof Swal !== 'undefined') {
            Swal.fire({
                icon: 'success',
                title: 'Contraseña copiada',
                showConfirmButton: false,
                timer: 1500
            });
        } else {
            alert('Contraseña copiada');
        }
    });

    $('#reset-password-form').on('submit', function(e) {
        e.preventDefault();
        
        $('.text-red-500').addClass('hidden').text('');
        
        const btn = $('#btn-guardar');
        const originalText = btn.html();
        btn.prop('disabled', true).html('<span class="material-symbols-outlined mr-2 animate-spin">refresh</span> Procesando...');

        const usuarioId = $('#usuario_id').val();
        const password = $('#password').val();

        if (!usuarioId) {
             Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'No se encontró el ID del usuario.'
            });
            btn.prop('disabled', false).html(originalText);
            return;
        }

        $.ajax({
            url: "{{ url('/rusuario') }}/" + usuarioId + "/updatePassword", // Ajustar ruta según web.php
            method: 'POST',
            data: {
                _token: $('meta[name="csrf-token"]').attr('content'),
                password: password
            },
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: '¡Éxito!',
                        text: 'Contraseña actualizada correctamente.',
                        showConfirmButton: false,
                        timer: 2000
                    }).then(() => {
                        window.location.href = "{{ url('/dashboard/usuario') }}";
                    });
                } else {
                     Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message || 'Error al actualizar.'
                    });
                     btn.prop('disabled', false).html(originalText);
                }
            },
            error: function(xhr) {
                btn.prop('disabled', false).html(originalText);
                 if (xhr.status === 422) {
                    let errors = xhr.responseJSON.errors;
                    if (errors.password) {
                        $('#error-password').text(errors.password[0]).removeClass('hidden');
                    }
                     Swal.fire({
                        icon: 'error',
                        title: 'Error de Validación',
                        text: 'Verifique los datos ingresados.'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: xhr.responseJSON?.message || 'Ocurrió un error inesperado.'
                    });
                }
            }
        });
    });
});
</script>
@endsection
