<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        @include('partials.front.styles')

        <title>Login</title>
        @vite('resources/css/app.css')
    </head>
    <body>
        <!-- Light/Dark Mode Button -->
        <button type="button" class="light-dark-toggle leading-none inline-block transition-all text-[#fe7a36] absolute top-[20px] md:top-[25px] ltr:right-[20px] rtl:left-[20px] ltr:md:right-[25px] rtl:md:left-[25px]" id="light-dark-toggle">
            <i class="material-symbols-outlined !text-[20px] md:!text-[22px]">
                light_mode
            </i>
        </button>
        <!-- End Light/Dark Mode Button -->

        <!-- Alert Container -->
        <div id="alert-container" class="mb-4"></div>

        <!-- Sign In -->
        <div class="bg-white dark:bg-[#0a0e19] py-[60px] md:py-[80px] lg:py-[135px]">
            <div class="mx-auto px-[12.5px] md:max-w-[720px] lg:max-w-[960px] xl:max-w-[1255px]">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-[25px] items-center">
                    <div class="xl:ltr:-mr-[25px] xl:rtl:-ml-[25px] 2xl:ltr:-mr-[45px] 2xl:rtl:-ml-[45px] rounded-[25px] order-2 lg:order-1">
                        <img src="/assets/images/sign-in.jpg" alt="sign-in-image" class="rounded-[25px]">
                    </div>
                    <div class="xl:ltr:pl-[90px] xl:rtl:pr-[90px] 2xl:ltr:pl-[120px] 2xl:rtl:pr-[120px] order-1 lg:order-2">
                        <img src="/assets/images/logo-big.svg" alt="logo" class="inline-block dark:hidden">
                        <img src="/assets/images/white-logo-big.svg" alt="logo" class="hidden dark:inline-block">
                        <div class="my-[17px] md:my-[25px]">
                            <h1 class="!font-semibold !text-[22px] md:!text-xl lg:!text-2xl !mb-[5px] md:!mb-[7px]">
                                Bienvenido:
                            </h1>
                        </div>
                        <div id="alert-container"></div>
                        <!-- Login Form -->
                        <form id="loginForm" autocomplete="off">
                            @csrf
                            <div class="mb-[15px] relative">
                                <label class="mb-[10px] md:mb-[12px] text-black dark:text-white font-medium block">
                                    Email
                                </label>
                                <input id="email" type="email" class="h-[55px] rounded-md text-black dark:text-white border border-gray-200 dark:border-[#172036] bg-white dark:bg-[#0c1427] px-[17px] block w-full outline-0 transition-all placeholder:text-gray-500 dark:placeholder:text-gray-400 focus:border-primary-500" placeholder="Type username">
                            </div>
                            <div class="mb-[15px] relative" id="passwordHideShow">
                                <label class="mb-[10px] md:mb-[12px] text-black dark:text-white font-medium block">
                                    Password
                                </label>
                                <input type="password" id="password" class="h-[55px] rounded-md text-black dark:text-white border border-gray-200 dark:border-[#172036] bg-white dark:bg-[#0c1427] px-[17px] block w-full outline-0 transition-all placeholder:text-gray-500 dark:placeholder:text-gray-400 focus:border-primary-500" placeholder="Type password">
                                <button class="absolute text-lg ltr:right-[20px] rtl:left-[20px] bottom-[12px] transition-all hover:text-primary-500" id="toggleButton" type="button">
                                    <i class="ri-eye-off-line"></i>
                                </button>
                            </div>
                            <button type="submit" id="loginBtn" class="md:text-md block w-full text-center transition-all rounded-md font-medium mt-[20px] md:mt-[25px] py-[12px] px-[25px] text-white bg-primary-500 hover:bg-primary-400">
                                <span class="flex items-center justify-center gap-[5px]">
                                    <!-- Spinner oculto -->
                                    <span class="loading-spinner hidden">
                                        <i class="material-symbols-outlined animate-spin">progress_activity</i>
                                    </span>

                                    <!-- Icono normal -->
                                    <span class="login-icon">
                                        <i class="material-symbols-outlined">login</i>
                                    </span>

                                    <!-- Texto -->
                                    <span class="button-text">Sign In</span>
                                </span>
                            </button>
                        </form>
                        <!-- End Login Form -->
                    </div>
                </div>
            </div>
        </div>
        <!-- End Sign In -->

        @include('partials.front.scripts')

        <script>
            $(document).ready(function() {

                // Configurar CSRF token para AJAX
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                // Validación en tiempo real
                $('#email').on('blur', function() {
                    //validateEmail($(this));
                });

                $('#password').on('blur', function() {
                    //validatePassword($(this));
                });

                // Limpiar errores al escribir
                $('#email, #password').on('input', function() {
                    //clearFieldError($(this));
                });

                // Envío del formulario
                $('#loginForm').on('submit', function(e) {
                    e.preventDefault();

                    // Validar campos

                    const emailValid = validateFields($('#email'),'Email',8);
                    const passwordValid = validateFields($('#password'),'Password',8);

                    if (!emailValid || !passwordValid) {
                        $.showSimpleToast('Por favor, corrige los errores antes de continuar.', 'error');
                        return;
                    }

                   const formData = {
                        email: $('#email').val(),
                        password: $('#password').val()
                    };
                    // Mostrar estado de carga
                    showLoading(true);

                    // Realizar petición AJAX
                    $.ajax({
                        url: '{{ route("login") }}',
                        type: 'POST',
                        data: formData,
                        dataType: 'json',
                        success: function(response) {
                            showLoading(false);

                            if (response.success) {
                                $.showSimpleToast('¡Login exitoso! Redirigiendo al sistema...', 'success', 5000);
                                //showAlert('¡Login exitoso! Redirigiendo...', 'success');

                                setTimeout(function() {
                                    window.location.href = response.redirect || '/fibra2/main';
                                }, 1500);

                            } else {
                                $.showSimpleToast(response.message || 'Error en el login', 'error');
                            }

                        },
                        error: function(xhr, status, error) {
                            showLoading(false);

                            if (xhr.status === 422) {
                                const errors = xhr.responseJSON.errors;
                                handleValidationErrors(errors);
                                $.showSimpleToast('Por favor, corrige los errores en el formulario.', 'error');
                            } else if (xhr.status === 401) {
                                $.showSimpleToast('Credenciales incorrectas. Verifica tu email y contraseña.', 'error');
                            } else if (xhr.status === 429) {
                                $.showSimpleToast('Demasiados intentos. Espera unos minutos antes de intentar de nuevo.', 'error');
                            } else {
                                $.showSimpleToast('Error de conexión. Inténtalo de nuevo.', 'error');
                            }

                        }
                    });
                });

                // Funciones de validación
                function validateFields(element,field,length) {
                    const campo = element.val();
                    if (campo === '') {
                        $.showSimpleToast('El '+field+' es obligatorio. No debe estar vac&iacute;o.', 'error');
                        return false;
                    } else if (campo.length < length) {
                        $.showSimpleToast('El '+field+' debe tener al menos '+length+' caracteres.','error');
                        return false;
                    } else {
                        return true;
                    }
                }

                function showLoading(show) {
                    const button = $('#loginBtn');
                    const spinner = button.find('.loading-spinner');
                    const loginIcon = button.find('.login-icon');
                    const buttonText = button.find('.button-text');

                    if (show) {
                        button.prop('disabled', true);
                        spinner.removeClass('hidden');
                        loginIcon.addClass('hidden');
                        buttonText.text('Verificando...');
                    } else {
                        button.prop('disabled', false);
                        spinner.addClass('hidden');
                        loginIcon.removeClass('hidden');
                        buttonText.text('Sign In');
                    }
                }

            });
        </script>

    </body>
</html>
