<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\AsignacionController;
use App\Http\Controllers\ProyectoController;
use App\Http\Controllers\RProyectoController;
use App\Http\Controllers\PersonaController;
use App\Http\Controllers\HpInstalacionController;
use App\Http\Controllers\RPersonaController;
use App\Http\Controllers\RUsuarioController;
use App\Http\Controllers\RUbicacionController;
use App\Http\Controllers\RCodigoPostalController;
use App\Http\Controllers\RCalleController;
use App\Http\Controllers\RCasaController;
use App\Http\Controllers\RHpInstalacionController;
use App\Http\Controllers\RHpImagenController;
use App\Http\Controllers\HpInformeController;
use App\Http\Controllers\UsuarioController;
use App\Http\Controllers\PerfilController;
use App\Http\Controllers\MailController;

Route::get('lang/{lang}', function($lang){
	session(['lang' => $lang]);
	return redirect()->back();
})->name('change-language');

Route::get('login', [LoginController::class, 'create'])->name('login');
Route::post('login', [LoginController::class, 'store']);
Route::post('logout', [LoginController::class, 'destroy'])->name('logout')->middleware('auth');
Route::get('/main', [HomeController::class,'index'])->name('main')->middleware('auth');

Route::get('home', [HomeController::class,'index'])->name('home')->middleware('auth');

Route::resource('rproyecto', RProyectoController::class);
Route::get('proyecto', [ProyectoController::class, 'index'])->name('proyecto.index')->middleware('auth');

Route::resource('rpersona', RPersonaController::class);
Route::resource('rusuario', RUsuarioController::class);
Route::post('rusuario/{id}/updatePassword', [RUsuarioController::class, 'updatePassword']);
Route::post('rpersona/updateProfile', [RPersonaController::class, 'updateProfile']);
Route::post('rusuario/updateProfileEmail', [RUsuarioController::class, 'updateProfileEmail']);
Route::post('rusuario/updateProfilePassword', [RUsuarioController::class, 'updateProfilePassword']);
Route::resource('rubicacion', RUbicacionController::class);
Route::resource('rcodigopostal', RCodigoPostalController::class);
Route::resource('rcalle', RCalleController::class);
Route::resource('rcasa', RCasaController::class);

Route::get('rhpinstalacion/getData', [RHpInstalacionController::class, 'getData'])->name('rhpinstalacion.getData');
Route::get('rhpinstalacion/getById/{id}', [RHpInstalacionController::class, 'getById']);
Route::get('rhpinstalacion/getByDate', [RHpInstalacionController::class, 'getByDate']);
Route::get('rhpinstalacion/getInstalacionById/{id}', [RHpInstalacionController::class, 'getInstalacionById']);
Route::resource('rhpinstalacion', RHpInstalacionController::class);

Route::resource('rhpimagen', RHpImagenController::class);
Route::post('rhpimagen/upload', [RHpImagenController::class, 'upload']);

Route::middleware('auth')->group(function () {
    Route::get('dashboard/persona', [PersonaController::class, 'index'])->name('persona.index');
    Route::get('dashboard/persona/new', [PersonaController::class, 'create'])->name('persona.create');
    Route::get('dashboard/persona/{id}/edit', [PersonaController::class, 'edit'])->name('persona.edit');
});

Route::get('dashboard/asignacion', [AsignacionController::class, 'index'])->name('asignacion.index');
Route::get('dashboard/asignacion/list', [AsignacionController::class, 'list'])->name('asignacion.list');

Route::middleware('auth')->group(function () {
    Route::get('dashboard/hpinstalacion', [HpInstalacionController::class, 'index'])->name('hpinstalacion.index');
    Route::get('dashboard/hpinstalacion/{id}/edit', [HpInstalacionController::class, 'edit'])->name('hpinstalacion.edit');
    Route::get('dashboard/hpinstalacionjob', [HpInstalacionController::class, 'indexjob'])->name('hpinstalacionjob.indexjob');
    Route::get('dashboard/hpinstalacionjob/{id}/edit', [HpInstalacionController::class, 'editjob'])->name('hpinstalacionjob.editjob');
});

Route::middleware('auth')->group(function () {
    Route::get('dashboard/usuario', [UsuarioController::class, 'index'])->name('usuario.index');
    Route::get('dashboard/usuario/new', [UsuarioController::class, 'create'])->name('usuario.create');
    Route::get('dashboard/usuario/{id}/edit', [UsuarioController::class, 'edit'])->name('usuario.edit');
    Route::get('dashboard/usuario/{id}/reset', [UsuarioController::class, 'resetPassword'])->name('usuario.reset');
});

Route::middleware('auth')->group(function () {
    Route::get('dashboard/informejob/{id}', [HpInformeController::class, 'informejob'])->name('hpinformejob.informejob');
});

Route::middleware('auth')->group(function () {
    Route::get('dashboard/perfil', [PerfilController::class, 'index'])->name('perfil.index');
});