<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <?php echo $__env->make('partials.front.styles', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->yieldContent('stylesCSS'); ?>
        <title>Dashboard</title>

        <?php echo app('Illuminate\Foundation\Vite')('resources/css/app.css'); ?>

    </head>
    <body>
        <?php echo $__env->make('partials.dashboard.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->make('partials.dashboard.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <div class="main-content transition-all flex flex-col overflow-hidden min-h-screen" id="main-content">


            <!-- Breadcrumb -->
            <div class="mb-[25px] md:flex items-center justify-between">
                <?php echo $__env->yieldContent('headerContent'); ?>
            </div>

            <!-- Blank Page -->
            <div class="trezo-card bg-white dark:bg-[#0c1427] mb-[25px] p-[20px] md:p-[25px] rounded-md">
                <div class="trezo-card-header mb-[20px] md:mb-[25px] flex items-center justify-between">
                    <div class="trezo-card-title">
                        <?php echo $__env->yieldContent('titleContent'); ?>
                    </div>
                </div>
                <div class="trezo-card-content">
                    <?php echo $__env->yieldContent('bodyContent'); ?>
                </div>
            </div>

            <div class="grow"></div>
            <?php echo $__env->make('partials.dashboard.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>

        <?php echo $__env->make('partials.front.scripts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->yieldContent('scriptsJS'); ?>
    </body>
</html>
<?php /**PATH /home/rad2crm/public_html/fibra2/resources/views/master.blade.php ENDPATH**/ ?>