<?php $__env->startSection('headerContent'); ?>
    <h5 class="!mb-0">
        Blank Page
    </h5>
    <ol class="breadcrumb mt-[12px] md:mt-0">
        <li class="breadcrumb-item inline-block relative text-sm mx-[11px] ltr:first:ml-0 rtl:first:mr-0 ltr:last:mr-0 rtl:last:ml-0">
            <a href="/main" class="inline-block relative ltr:pl-[22px] rtl:pr-[22px] transition-all hover:text-primary-500">
                <i class="material-symbols-outlined absolute ltr:left-0 rtl:right-0 !text-lg -mt-px text-primary-500 top-1/2 -translate-y-1/2">
                    home
                </i>
                Dashboard
            </a>
        </li>
        <li class="breadcrumb-item inline-block relative text-sm mx-[11px] ltr:first:ml-0 rtl:first:mr-0 ltr:last:mr-0 rtl:last:ml-0">
            Blank Page
        </li>
    </ol>
<?php $__env->stopSection(); ?> 

<?php $__env->startSection('titleContent'); ?>
    <h5 class="!mb-0">
        Menu Principal
    </h5>
<?php $__env->stopSection(); ?> 

<?php $__env->startSection('bodyContent'); ?>


    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-[25px]">
        <?php $__currentLoopData = $menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                // Usar color de la base de datos o 'blue' por defecto
                $color = $d->color ?? 'blue';
                
                $theme = [
                    'bg_card' => "hover:shadow-{$color}-500/10 hover:border-{$color}-200 dark:hover:border-{$color}-800",
                    'icon_bg' => "bg-{$color}-50 text-{$color}-600 dark:bg-{$color}-900/20 dark:text-{$color}-400",
                    'icon_hover' => "group-hover:bg-{$color}-600 group-hover:text-white",
                    'title_hover' => "group-hover:text-{$color}-600 dark:group-hover:text-{$color}-400",
                ];
            ?>
            
            <a href="<?php echo e($d->directorio); ?>" class="group relative flex flex-col items-center justify-center text-center p-[30px] rounded-xl bg-white dark:bg-[#0c1427] border border-gray-100 dark:border-[#172036] shadow-sm transition-all duration-300 hover:-translate-y-1.5 hover:shadow-lg <?php echo e($theme['bg_card']); ?>">
                
                <div class="mb-[20px] w-[70px] h-[70px] rounded-2xl flex items-center justify-center transition-all duration-300 shadow-sm group-hover:scale-110 <?php echo e($theme['icon_bg']); ?> <?php echo e($theme['icon_hover']); ?>">
                    <span class="material-symbols-outlined !text-[36px]">
                        <?php echo e($d->icono ?? 'grid_view'); ?>

                    </span>
                </div>
                
                <h6 class="text-[17px] font-bold text-gray-800 dark:text-gray-100 mb-[8px] tracking-wide transition-colors duration-300 <?php echo e($theme['title_hover']); ?>">
                    <?php echo e($d->nombre_menu); ?>

                </h6>
                
                <?php if(isset($d->descripcion)): ?>
                    <p class="text-gray-500 dark:text-gray-400 text-sm leading-relaxed px-2">
                        <?php echo e($d->descripcion); ?>

                    </p>
                <?php endif; ?>

                <!-- Elemento decorativo sutil en hover -->
                <div class="absolute inset-0 border-2 border-transparent rounded-xl transition-all duration-300 group-hover:border-opacity-50 pointer-events-none"></div>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php $__env->stopSection(); ?> 

<?php echo $__env->make('master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/rad2crm/public_html/fibra2/resources/views/main.blade.php ENDPATH**/ ?>